/*
 * Decompiled with CFR 0.152.
 */
package ball.activation;

import ball.activation.AbstractDataSource;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import lombok.Generated;

public class TempFileDataSource
extends AbstractDataSource {
    private final String prefix;
    private final String suffix;
    private final File parent;
    private volatile File file = null;

    @ConstructorProperties(value={"", "", "", "contentType"})
    public TempFileDataSource(String prefix, String suffix, File parent, String type) {
        try {
            this.clear();
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        this.prefix = prefix != null ? prefix : TempFileDataSource.class.getSimpleName();
        this.suffix = suffix;
        this.parent = parent;
        if (type != null) {
            this.setContentType(type);
        }
    }

    @ConstructorProperties(value={"contentType"})
    public TempFileDataSource(String type) {
        this(null, null, null, type);
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public FileInputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public FileOutputStream getOutputStream() throws IOException {
        FileOutputStream out = null;
        File old = this.file;
        if (old != null) {
            old.delete();
        }
        this.file = File.createTempFile(this.prefix, this.suffix, this.parent);
        this.file.deleteOnExit();
        out = new FileOutputStream(this.file);
        return out;
    }

    @Override
    @Generated
    public String toString() {
        return "TempFileDataSource(prefix=" + this.prefix + ", suffix=" + this.suffix + ", parent=" + this.parent + ", file=" + this.file + ")";
    }
}

