/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.processing.AbstractProcessor;
import ball.annotation.processing.ForElementKinds;
import ball.annotation.processing.ForSubclassesOf;
import ball.annotation.processing.MustImplement;
import ball.annotation.processing.WithModifiers;
import ball.annotation.processing.WithoutModifiers;
import ball.util.Walker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;

public abstract class AnnotatedNoAnnotationProcessor
extends AbstractProcessor {
    protected final List<Predicate<Element>> criteria = new ArrayList<Predicate<Element>>();
    protected final List<Consumer<Element>> checks = new ArrayList<Consumer<Element>>();

    protected EnumSet<ElementKind> getForElementKinds() {
        EnumSet value = null;
        if (this.getClass().isAnnotationPresent(ForElementKinds.class)) {
            Enum[] array = this.getClass().getAnnotation(ForElementKinds.class).value();
            value = this.toEnumSet(array);
        }
        return value;
    }

    protected EnumSet<Modifier> getWithModifiers() {
        EnumSet value = null;
        if (this.getClass().isAnnotationPresent(WithModifiers.class)) {
            Enum[] array = this.getClass().getAnnotation(WithModifiers.class).value();
            value = this.toEnumSet(array);
        }
        return value;
    }

    protected EnumSet<Modifier> getWithoutModifiers() {
        EnumSet value = null;
        if (this.getClass().isAnnotationPresent(WithoutModifiers.class)) {
            Enum[] array = this.getClass().getAnnotation(WithoutModifiers.class).value();
            value = this.toEnumSet(array);
        }
        return value;
    }

    protected Class<?> getForSubclassesOf() {
        Class<?> value = null;
        if (this.getClass().isAnnotationPresent(ForSubclassesOf.class)) {
            value = this.getClass().getAnnotation(ForSubclassesOf.class).value();
        }
        return value;
    }

    protected Class<?>[] getMustImplement() {
        Class<?>[] value = null;
        if (this.getClass().isAnnotationPresent(MustImplement.class)) {
            value = this.getClass().getAnnotation(MustImplement.class).value();
        }
        return value;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        try {
            EnumSet<ElementKind> kinds = EnumSet.allOf(ElementKind.class);
            this.criteria.add(t -> kinds.contains((Object)t.getKind()));
            if (this.getClass().isAnnotationPresent(ForElementKinds.class)) {
                kinds.retainAll(this.getForElementKinds());
            }
            if (this.getClass().isAnnotationPresent(WithModifiers.class)) {
                this.criteria.add(this.withModifiers(this.getWithModifiers()));
            }
            if (this.getClass().isAnnotationPresent(WithoutModifiers.class)) {
                this.criteria.add(this.withoutModifiers(this.getWithoutModifiers()));
            }
            if (this.getClass().isAnnotationPresent(ForSubclassesOf.class)) {
                kinds.retainAll(ForSubclassesOf.ELEMENT_KINDS);
                this.criteria.add(this.isAssignableTo(this.getForSubclassesOf()));
            }
            if (this.getClass().isAnnotationPresent(MustImplement.class)) {
                this.criteria.add(new MustImplementCriterion());
            }
        }
        catch (Exception exception) {
            this.criteria.clear();
            this.criteria.add(t -> false);
            this.print(Diagnostic.Kind.WARNING, "%s disabled", this.getClass().getName());
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            Walker.walk(roundEnv.getRootElements(), Element::getEnclosedElements).filter(this.criteria.stream().reduce(t -> true, Predicate::and)).peek(this.checks.stream().reduce(t -> {}, Consumer::andThen)).forEach(t -> this.process(roundEnv, (Element)t));
        }
        catch (Throwable throwable) {
            this.print(Diagnostic.Kind.ERROR, throwable);
        }
        return false;
    }

    protected void process(RoundEnvironment roundEnv, Element element) {
    }

    @Generated
    protected AnnotatedNoAnnotationProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "AnnotatedNoAnnotationProcessor(criteria=" + this.criteria + ", checks=" + this.checks + ")";
    }

    private class MustImplementCriterion
    extends AbstractProcessor.Criterion<Element> {
        private final Class<?>[] types;

        @Override
        public boolean test(Element element) {
            boolean match = AnnotatedNoAnnotationProcessor.this.withoutModifiers(Modifier.ABSTRACT).test(element);
            if (match) {
                for (Class<?> type : this.types) {
                    if (AnnotatedNoAnnotationProcessor.this.isAssignableTo(type).test(element)) continue;
                    match &= false;
                    AnnotatedNoAnnotationProcessor.this.print(Diagnostic.Kind.ERROR, element, "@%s: @%s does not implement %s", new Object[]{MustImplement.class.getSimpleName(), element.getKind(), type.getName()});
                }
            }
            return match;
        }

        @Generated
        public MustImplementCriterion() {
            super(AnnotatedNoAnnotationProcessor.this);
            this.types = AnnotatedNoAnnotationProcessor.this.getMustImplement();
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedNoAnnotationProcessor.MustImplementCriterion(types=" + Arrays.deepToString(this.types) + ")";
        }
    }
}

