/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.processing.AbstractProcessor;
import ball.annotation.processing.AnnotationValueMustConvertTo;
import ball.annotation.processing.COMPILATIONFinishedTaskListener;
import ball.annotation.processing.ClassFileProcessor;
import ball.annotation.processing.For;
import ball.annotation.processing.TargetMustBe;
import ball.annotation.processing.TargetMustExtend;
import ball.annotation.processing.TargetMustHaveConstructor;
import ball.annotation.processing.TargetMustHaveModifiers;
import ball.annotation.processing.TargetMustNotHaveModifiers;
import java.beans.ConstructorProperties;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import lombok.Generated;

public abstract class AnnotatedProcessor
extends AbstractProcessor {
    private final Set<String> processed = new TreeSet<String>();

    protected List<Class<? extends Annotation>> getSupportedAnnotationTypeList() {
        return Arrays.asList(this.getClass().getAnnotation(For.class).value());
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        Set<String> set = this.getSupportedAnnotationTypeList().stream().map(Class::getCanonicalName).collect(Collectors.toSet());
        return set;
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        try {
            if (this instanceof ClassFileProcessor) {
                COMPILATIONFinishedTaskListener listener = new COMPILATIONFinishedTaskListener(this.javac, this.elements, this.processed, () -> this.onCOMPILATIONFinished());
                this.javac.addTaskListener(listener);
            }
        }
        catch (Exception exception) {
            this.print(Diagnostic.Kind.ERROR, exception);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        annotations.stream().forEach(t -> this.process(roundEnv, (TypeElement)t));
        return true;
    }

    private void process(RoundEnvironment roundEnv, TypeElement annotation) {
        try {
            roundEnv.getElementsAnnotatedWith(annotation).stream().peek(t -> this.processed.add(this.getEnclosingTypeBinaryName((Element)t))).peek(new AnnotationValueMustConvertToCheck(annotation)).peek(new TargetMustBeCheck(annotation)).peek(new TargetMustHaveModifiersCheck(annotation)).peek(new TargetMustNotHaveModifiersCheck(annotation)).peek(new TargetMustExtendCheck(annotation)).peek(new TargetMustHaveConstructorCheck(annotation)).forEach(t -> this.process(roundEnv, annotation, (Element)t));
        }
        catch (Throwable throwable) {
            this.print(Diagnostic.Kind.ERROR, throwable);
        }
    }

    protected void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
    }

    private String getEnclosingTypeBinaryName(Element element) {
        String name = null;
        switch (element.getKind()) {
            case ANNOTATION_TYPE: 
            case CLASS: 
            case ENUM: 
            case INTERFACE: {
                name = this.elements.getBinaryName((TypeElement)element).toString();
                break;
            }
            case PACKAGE: {
                name = ((PackageElement)element).getQualifiedName().toString() + ".package-info";
                break;
            }
            default: {
                name = this.getEnclosingTypeBinaryName(element.getEnclosingElement());
            }
        }
        return name;
    }

    private void onCOMPILATIONFinished() {
        HashSet set = new HashSet();
        try {
            ClassLoader loader = this.getClassPathClassLoader(this.fm);
            for (String name : ClassFileProcessor.list(this.fm)) {
                try {
                    set.add(Class.forName(name, true, loader));
                }
                catch (Throwable throwable) {}
            }
            ((ClassFileProcessor)((Object)this)).process(set, this.fm);
        }
        catch (Exception exception) {
            this.print(Diagnostic.Kind.ERROR, exception);
        }
    }

    @Generated
    protected AnnotatedProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "AnnotatedProcessor(processed=" + this.processed + ")";
    }

    private class TargetMustHaveConstructorCheck
    extends AbstractProcessor.Check<Element> {
        private final TypeElement annotation;

        @Override
        public void accept(Element element) {
            AnnotationMirror meta = AnnotatedProcessor.this.getAnnotationMirror((Element)this.annotation, TargetMustHaveConstructor.class);
            if (meta != null) {
                boolean found;
                AnnotationValue value = AnnotatedProcessor.this.getAnnotationValue(meta, "value");
                String name = ((VariableElement)value.getValue()).getSimpleName().toString();
                Modifier modifier = Modifier.valueOf(name);
                List<TypeMirror> parameters = Stream.of(AnnotatedProcessor.this.getAnnotationValue(meta, "parameters")).filter(Objects::nonNull).map(t -> (List)t.getValue()).flatMap(Collection::stream).map(t -> (AnnotationValue)t).map(t -> (TypeMirror)t.getValue()).collect(Collectors.toList());
                ExecutableElement constructor = AnnotatedProcessor.this.getConstructor((TypeElement)element, parameters);
                boolean bl = found = constructor != null && constructor.getModifiers().contains((Object)modifier);
                if (!found) {
                    AnnotatedProcessor.this.print(Diagnostic.Kind.ERROR, element, "@%s: No %s matching constructor", new Object[]{this.annotation.getSimpleName(), modifier});
                }
            }
        }

        @ConstructorProperties(value={"annotation"})
        @Generated
        public TargetMustHaveConstructorCheck(TypeElement annotation) {
            this.annotation = annotation;
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedProcessor.TargetMustHaveConstructorCheck(annotation=" + this.annotation + ")";
        }
    }

    private class TargetMustExtendCheck
    extends AbstractProcessor.Check<Element> {
        private final TypeElement annotation;

        @Override
        public void accept(Element element) {
            AnnotationMirror meta = AnnotatedProcessor.this.getAnnotationMirror((Element)this.annotation, TargetMustExtend.class);
            if (meta != null) {
                AnnotationValue value = AnnotatedProcessor.this.getAnnotationValue(meta, "value");
                TypeElement type = (TypeElement)AnnotatedProcessor.this.types.asElement((TypeMirror)value.getValue());
                if (!AnnotatedProcessor.this.types.isAssignable(element.asType(), type.asType())) {
                    AnnotatedProcessor.this.print(Diagnostic.Kind.ERROR, element, "@%s: %s does not extend %s", this.annotation.getSimpleName(), element, type.getQualifiedName());
                }
            }
        }

        @ConstructorProperties(value={"annotation"})
        @Generated
        public TargetMustExtendCheck(TypeElement annotation) {
            this.annotation = annotation;
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedProcessor.TargetMustExtendCheck(annotation=" + this.annotation + ")";
        }
    }

    private class TargetMustNotHaveModifiersCheck
    extends AbstractProcessor.Check<Element> {
        private final TypeElement annotation;

        @Override
        public void accept(Element element) {
            EnumSet modifiers;
            AnnotationMirror meta = AnnotatedProcessor.this.getAnnotationMirror((Element)this.annotation, TargetMustNotHaveModifiers.class);
            if (meta != null && !AnnotatedProcessor.this.withoutModifiers(modifiers = Stream.of(AnnotatedProcessor.this.getAnnotationValue(meta, "value")).filter(Objects::nonNull).map(t -> (List)t.getValue()).flatMap(Collection::stream).map(t -> ((AnnotationValue)t).getValue()).map(Objects::toString).map(Modifier::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class)))).test(element)) {
                AnnotatedProcessor.this.print(Diagnostic.Kind.ERROR, element, "%s must not be %s", new Object[]{element.getKind(), modifiers});
            }
        }

        @ConstructorProperties(value={"annotation"})
        @Generated
        public TargetMustNotHaveModifiersCheck(TypeElement annotation) {
            this.annotation = annotation;
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedProcessor.TargetMustNotHaveModifiersCheck(annotation=" + this.annotation + ")";
        }
    }

    private class TargetMustHaveModifiersCheck
    extends AbstractProcessor.Check<Element> {
        private final TypeElement annotation;

        @Override
        public void accept(Element element) {
            EnumSet modifiers;
            AnnotationMirror meta = AnnotatedProcessor.this.getAnnotationMirror((Element)this.annotation, TargetMustHaveModifiers.class);
            if (meta != null && !AnnotatedProcessor.this.withModifiers(modifiers = Stream.of(AnnotatedProcessor.this.getAnnotationValue(meta, "value")).filter(Objects::nonNull).map(t -> (List)t.getValue()).flatMap(Collection::stream).map(t -> ((AnnotationValue)t).getValue()).map(Objects::toString).map(Modifier::valueOf).collect(Collectors.toCollection(() -> EnumSet.noneOf(Modifier.class)))).test(element)) {
                AnnotatedProcessor.this.print(Diagnostic.Kind.ERROR, element, "%s must be %s", new Object[]{element.getKind(), modifiers});
            }
        }

        @ConstructorProperties(value={"annotation"})
        @Generated
        public TargetMustHaveModifiersCheck(TypeElement annotation) {
            this.annotation = annotation;
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedProcessor.TargetMustHaveModifiersCheck(annotation=" + this.annotation + ")";
        }
    }

    private class TargetMustBeCheck
    extends AbstractProcessor.Check<Element> {
        private final TypeElement annotation;

        @Override
        public void accept(Element element) {
            AnnotationValue value;
            String name;
            ElementKind kind;
            AnnotationMirror meta = AnnotatedProcessor.this.getAnnotationMirror((Element)this.annotation, TargetMustBe.class);
            if (meta != null && !(kind = ElementKind.valueOf(name = ((VariableElement)(value = AnnotatedProcessor.this.getAnnotationValue(meta, "value")).getValue()).getSimpleName().toString())).equals((Object)element.getKind())) {
                AnnotatedProcessor.this.print(Diagnostic.Kind.ERROR, element, "@%s: %s is not a %s", new Object[]{this.annotation.getSimpleName(), element.getKind(), kind});
            }
        }

        @ConstructorProperties(value={"annotation"})
        @Generated
        public TargetMustBeCheck(TypeElement annotation) {
            this.annotation = annotation;
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedProcessor.TargetMustBeCheck(annotation=" + this.annotation + ")";
        }
    }

    private class AnnotationValueMustConvertToCheck
    extends AbstractProcessor.Check<Element> {
        private final TypeElement annotation;

        @Override
        public void accept(Element element) {
            AnnotationMirror meta = AnnotatedProcessor.this.getAnnotationMirror((Element)this.annotation, AnnotationValueMustConvertTo.class);
            if (meta != null) {
                AnnotationValue value = AnnotatedProcessor.this.getAnnotationValue(meta, "value");
                TypeElement to = (TypeElement)AnnotatedProcessor.this.types.asElement((TypeMirror)value.getValue());
                String method = (String)AnnotatedProcessor.this.getAnnotationValue(meta, "method").getValue();
                String name = (String)AnnotatedProcessor.this.getAnnotationValue(meta, "name").getValue();
                AnnotationMirror mirror = AnnotatedProcessor.this.getAnnotationMirror(element, this.annotation);
                AnnotationValue from = null;
                try {
                    from = AnnotatedProcessor.this.getAnnotationValue(mirror, name);
                    Class<?> type = Class.forName(to.getQualifiedName().toString());
                    if (!method.isEmpty()) {
                        type.getMethod(method, from.getValue().getClass()).invoke(null, from.getValue());
                    } else {
                        type.getConstructor(from.getValue().getClass()).newInstance(from.getValue());
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    while (throwable instanceof InvocationTargetException) {
                        throwable = throwable.getCause();
                    }
                    AnnotatedProcessor.this.print(Diagnostic.Kind.ERROR, element, mirror, "Cannot convert %s to %s\n%s", from, to.getQualifiedName(), throwable.getMessage());
                }
            }
        }

        @ConstructorProperties(value={"annotation"})
        @Generated
        public AnnotationValueMustConvertToCheck(TypeElement annotation) {
            this.annotation = annotation;
        }

        @Override
        @Generated
        public String toString() {
            return "AnnotatedProcessor.AnnotationValueMustConvertToCheck(annotation=" + this.annotation + ")";
        }
    }
}

