/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.ClassFileProcessor;
import ball.annotation.processing.For;
import ball.util.ant.taskdefs.AntLib;
import ball.util.ant.taskdefs.AntTask;
import ball.xml.FluentDocument;
import ball.xml.FluentDocumentBuilderFactory;
import ball.xml.XalanConstants;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.Processor;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import lombok.Generated;
import org.apache.tools.ant.Task;

@ServiceProviderFor(value={Processor.class})
@For(value={AntLib.class, AntTask.class})
public class AntLibProcessor
extends AnnotatedProcessor
implements ClassFileProcessor,
XalanConstants {
    private static final String ANTLIB_XML = "antlib.xml";
    private static final Transformer TRANSFORMER;

    @Override
    public void process(Set<Class<?>> set, JavaFileManager fm) throws Exception {
        TreeSet<String> paths = new TreeSet<String>();
        AntLibXML antlib = new AntLibXML();
        for (Class<?> type : set) {
            AntLib lib;
            AntTask annotation = type.getAnnotation(AntTask.class);
            if (annotation != null && Task.class.isAssignableFrom(type) && !Modifier.isAbstract(type.getModifiers())) {
                antlib.put(annotation.value(), type);
            }
            if ((lib = type.getAnnotation(AntLib.class)) == null) continue;
            paths.add(type.getPackage().getName());
        }
        for (String path : paths) {
            FileObject file = fm.getFileForOutput(StandardLocation.CLASS_OUTPUT, path, ANTLIB_XML, null);
            OutputStream out = file.openOutputStream();
            Throwable throwable = null;
            try {
                antlib.writeTo(out);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                out.close();
            }
        }
    }

    @Generated
    public AntLibProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "AntLibProcessor()";
    }

    static {
        try {
            TRANSFORMER = TransformerFactory.newInstance().newTransformer();
            TRANSFORMER.setOutputProperty("omit-xml-declaration", "no");
            TRANSFORMER.setOutputProperty("indent", "yes");
            TRANSFORMER.setOutputProperty(XALAN_INDENT_AMOUNT.toString(), String.valueOf(2));
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    private static class AntLibXML
    extends TreeMap<String, Class<?>> {
        private static final long serialVersionUID = -8903476717502118017L;

        public FluentDocument asDocument() throws Exception {
            FluentDocument d = FluentDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            d.add(d.element("antlib", this.entrySet().stream().map(t -> d.element("taskdef", d.attr("name", (String)t.getKey()), d.attr("classname", ((Class)t.getValue()).getName())))));
            return d;
        }

        public void writeTo(OutputStream out) throws Exception {
            TRANSFORMER.transform(new DOMSource(this.asDocument()), new StreamResult(out));
        }

        @Generated
        public AntLibXML() {
        }
    }
}

