/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.CompileTimeCheck;
import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.For;
import ball.tools.javac.AbstractTaskListener;
import com.sun.source.util.TaskEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@For(value={CompileTimeCheck.class})
public class CompileTimeCheckProcessor
extends AnnotatedProcessor {
    private static final EnumSet<Modifier> FIELD_MODIFIERS = EnumSet.of(Modifier.STATIC, Modifier.FINAL);
    private final Map<String, String> map = new TreeMap<String, String>();

    @Override
    protected void whenAnnotationProcessingFinished() {
        this.javac.addTaskListener(new TaskListenerImpl());
    }

    @Override
    protected void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
        super.process(roundEnv, annotation, element);
        switch (element.getKind()) {
            case FIELD: {
                TypeElement type = (TypeElement)element.getEnclosingElement();
                String key = type.getQualifiedName() + ":" + element.getSimpleName();
                String value = this.elements.getBinaryName(type).toString();
                if (this.map.containsKey(key)) break;
                if (this.with(FIELD_MODIFIERS, t -> t.getModifiers()).test(element)) {
                    this.map.put(key, value);
                    break;
                }
                this.print(Diagnostic.Kind.ERROR, element, "%s must be %s", new Object[]{element.getKind(), FIELD_MODIFIERS});
                break;
            }
            default: {
                throw new IllegalStateException(element.getKind().name());
            }
        }
    }

    @Generated
    public CompileTimeCheckProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "CompileTimeCheckProcessor(map=" + this.map + ")";
    }

    private class TaskListenerImpl
    extends AbstractTaskListener {
        @Override
        public void finished(TaskEvent event) {
            switch (event.getKind()) {
                case GENERATE: {
                    ClassLoader loader = CompileTimeCheckProcessor.this.getClassPathClassLoader(CompileTimeCheckProcessor.this.fm);
                    Iterator iterator = CompileTimeCheckProcessor.this.map.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        String[] names = ((String)entry.getKey()).split(":", 2);
                        TypeElement type = CompileTimeCheckProcessor.this.elements.getTypeElement(names[0]);
                        VariableElement element = ElementFilter.fieldsIn(type.getEnclosedElements()).stream().filter(t -> t.getSimpleName().contentEquals(names[1])).findFirst().orElse(null);
                        AnnotationMirror annotation = CompileTimeCheckProcessor.this.getAnnotationMirror((Element)element, CompileTimeCheck.class);
                        try {
                            Class.forName((String)entry.getValue(), true, loader);
                            iterator.remove();
                        }
                        catch (ClassNotFoundException exception) {
                        }
                        catch (NoClassDefFoundError error) {
                        }
                        catch (Throwable throwable) {
                            while (throwable instanceof ExceptionInInitializerError) {
                                throwable = throwable.getCause();
                            }
                            while (throwable instanceof InvocationTargetException) {
                                throwable = throwable.getCause();
                            }
                            CompileTimeCheckProcessor.this.print(Diagnostic.Kind.WARNING, (Element)element, "Invalid %s initializer\n%s: %s", new Object[]{element.getKind(), throwable.getClass().getName(), throwable.getMessage()});
                            iterator.remove();
                        }
                    }
                    break;
                }
            }
        }

        @Generated
        public TaskListenerImpl() {
        }

        @Override
        @Generated
        public String toString() {
            return "CompileTimeCheckProcessor.TaskListenerImpl()";
        }
    }
}

