/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ConstantValueMustConvertTo;
import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.For;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@For(value={ConstantValueMustConvertTo.class})
public class ConstantValueMustConvertToProcessor
extends AnnotatedProcessor {
    @Override
    public void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
        super.process(roundEnv, annotation, element);
        AnnotationMirror mirror = this.getAnnotationMirror(element, annotation);
        AnnotationValue value = this.getAnnotationValue(mirror, "value");
        TypeElement to = (TypeElement)this.types.asElement((TypeMirror)value.getValue());
        String method = (String)this.getAnnotationValue(mirror, "method").getValue();
        Object from = null;
        try {
            from = ((VariableElement)element).getConstantValue();
            Class<?> type = Class.forName(to.getQualifiedName().toString());
            if (!method.isEmpty()) {
                type.getMethod(method, from.getClass()).invoke(null, from);
            } else {
                type.getConstructor(from.getClass()).newInstance(from);
            }
        }
        catch (Exception exception) {
            Throwable throwable = exception;
            while (throwable instanceof InvocationTargetException) {
                throwable = throwable.getCause();
            }
            this.print(Diagnostic.Kind.ERROR, element, "Cannot convert %s to %s\n%s: %s", this.elements.getConstantExpression(from), to.getQualifiedName(), throwable.getClass().getName(), throwable.getMessage());
        }
    }

    @Generated
    public ConstantValueMustConvertToProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "ConstantValueMustConvertToProcessor()";
    }
}

