/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.For;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@ServiceProviderFor(value={Processor.class})
@For(value={ConstructorProperties.class})
public class ConstructorPropertiesProcessor
extends AnnotatedProcessor {
    @Override
    public void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
        super.process(roundEnv, annotation, element);
        AnnotationMirror mirror = this.getAnnotationMirror(element, annotation);
        AnnotationValue value = this.getAnnotationValue(mirror, "value");
        List names = Stream.of(value).filter(Objects::nonNull).map(t -> (List)t.getValue()).flatMap(Collection::stream).map(t -> (AnnotationValue)t).map(t -> (String)t.getValue()).collect(Collectors.toList());
        List<? extends VariableElement> parameters = ((ExecutableElement)element).getParameters();
        if (names.size() != parameters.size()) {
            this.print(Diagnostic.Kind.WARNING, element, mirror, value, "value() does not match %s parameters", new Object[]{element.getKind()});
        }
        TypeElement type = (TypeElement)element.getEnclosingElement();
        Set<String> properties = this.getPropertyNames(type);
        names.stream().filter(StringUtils::isNotEmpty).filter(t -> !properties.contains(t)).forEach(t -> this.print(Diagnostic.Kind.WARNING, element, mirror, "bean property '%s' not defined", t));
    }

    @Generated
    public ConstructorPropertiesProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "ConstructorPropertiesProcessor()";
    }
}

