/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedNoAnnotationProcessor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.For;
import ball.annotation.processing.ForElementKinds;
import ball.annotation.processing.TargetMustExtend;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@TargetMustExtend(value=AnnotatedNoAnnotationProcessor.class)
public @interface ForSubclassesOf {
    public static final EnumSet<ElementKind> ELEMENT_KINDS = Stream.of(ElementKind.values()).filter(t -> t.isClass() || t.isInterface()).collect(Collectors.toCollection(() -> EnumSet.noneOf(ElementKind.class)));

    public Class<?> value();

    @ServiceProviderFor(value={Processor.class})
    @For(value={ForSubclassesOf.class})
    public static class ProcessorImpl
    extends AnnotatedProcessor {
        @Override
        public void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
            super.process(roundEnv, annotation, element);
            ForElementKinds kinds = element.getAnnotation(ForElementKinds.class);
            if (kinds != null) {
                EnumSet<ElementKind> set = EnumSet.noneOf(ElementKind.class);
                Collections.addAll(set, kinds.value());
                if (!set.removeAll(ELEMENT_KINDS)) {
                    this.print(Diagnostic.Kind.ERROR, element, "%s annotated with @%s and @%s but does not specify one of %s", new Object[]{element.getKind(), annotation.getSimpleName(), ForElementKinds.class.getSimpleName(), ELEMENT_KINDS});
                }
                if (!set.isEmpty()) {
                    this.print(Diagnostic.Kind.WARNING, element, "%s annotated with @%s and @%s; %s will be ignored", new Object[]{element.getKind(), annotation.getSimpleName(), ForElementKinds.class.getSimpleName(), set});
                }
            }
        }

        @Generated
        public ProcessorImpl() {
        }

        @Override
        @Generated
        public String toString() {
            return "ForSubclassesOf.ProcessorImpl()";
        }
    }
}

