/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.ClassFileProcessor;
import ball.annotation.processing.For;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.Processor;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@For(value={XmlRootElement.class, XmlType.class})
public class JAXBIndexProcessor
extends AnnotatedProcessor
implements ClassFileProcessor {
    private static final String JAXB_INDEX = "jaxb.index";
    private static final String DOT = ".";
    private final Set<String> set = new TreeSet<String>();

    @Override
    public void process(Set<Class<?>> set, JavaFileManager fm) throws Exception {
        TreeMap<String, Set> map = new TreeMap<String, Set>();
        for (Class<?> clazz : set) {
            if (Modifier.isAbstract(clazz.getModifiers())) continue;
            for (Class<? extends Annotation> annotation : this.getSupportedAnnotationTypeList()) {
                if (!clazz.isAnnotationPresent(annotation)) continue;
                String key = clazz.getPackage().getName();
                String value = clazz.getCanonicalName().substring(key.length());
                if (value.startsWith(DOT)) {
                    value = value.substring(DOT.length());
                }
                map.computeIfAbsent(key, k -> new TreeSet()).add(value);
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            String path = JAXB_INDEX;
            FileObject file = fm.getFileForOutput(StandardLocation.CLASS_OUTPUT, (String)entry.getKey(), JAXB_INDEX, null);
            PrintWriter writer = new PrintWriter(file.openWriter());
            Throwable throwable = null;
            try {
                writer.println("# jaxb.index");
                ((Set)entry.getValue()).stream().forEach(t -> writer.println((String)t));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    @Generated
    public JAXBIndexProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "JAXBIndexProcessor(set=" + this.set + ")";
    }
}

