/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.beans.PropertyMethodEnum;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import lombok.Generated;

public abstract class JavaxLangModelUtilities {
    private static final ModifierMap MODIFIERS = new ModifierMap();
    private static final List<Class<? extends Annotation>> GENERATED_ANNOTATION_LIST;
    protected Elements elements = null;
    protected Types types = null;
    protected JavaFileManager fm = null;
    private transient ClassLoader loader = null;

    protected ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = this.getClassPathClassLoader(this.fm, this.getClass().getClassLoader());
        }
        return this.loader;
    }

    protected boolean isGenerated(Element element) {
        boolean isGenerated = false;
        if (element != null) {
            for (Class<? extends Annotation> annotation : GENERATED_ANNOTATION_LIST) {
                if (isGenerated |= element.getAnnotation(annotation) != null) break;
            }
            if (!isGenerated) {
                isGenerated |= this.isGenerated(element.getEnclosingElement());
            }
        }
        return isGenerated;
    }

    protected Class<?> asClass(TypeElement element) {
        Class<?> type = null;
        Name name = this.elements.getBinaryName(element);
        if (name == null) {
            name = element.getQualifiedName();
        }
        try {
            type = this.getClassLoader().loadClass(name.toString());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("type=" + name, exception);
        }
        return type;
    }

    protected Class<?> asPackageInfoClass(PackageElement element) {
        Class<?> type = null;
        String name = element.getQualifiedName().toString() + ".package-info";
        try {
            type = this.getClassLoader().loadClass(name);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("type=" + name, exception);
        }
        return type;
    }

    protected TypeElement asTypeElement(Class<?> type) {
        TypeElement element = null;
        try {
            element = this.elements.getTypeElement(type.getCanonicalName());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("type=" + type, exception);
        }
        return element;
    }

    protected ExecutableElement asExecutableElement(Constructor<?> constructor) {
        TypeElement type = this.asTypeElement(constructor.getDeclaringClass());
        Element element = ElementFilter.constructorsIn(type.getEnclosedElements()).stream().filter(this.hasSameSignatureAs(constructor)).findFirst().orElse(null);
        return (ExecutableElement)element;
    }

    protected ExecutableElement asExecutableElement(Method method) {
        return this.getMethod(this.asTypeElement(method.getDeclaringClass()), method);
    }

    protected VariableElement asVariableElement(Field field) {
        TypeElement type = this.asTypeElement(field.getDeclaringClass());
        Element element = ElementFilter.fieldsIn(type.getEnclosedElements()).stream().filter(t -> t.getSimpleName().contentEquals(field.getName())).findFirst().orElse(null);
        return (VariableElement)element;
    }

    protected TypeMirror asTypeMirror(Class<?> type) {
        TypeMirror mirror = null;
        mirror = type.isArray() ? this.types.getArrayType(this.asTypeMirror(type.getComponentType())) : (type.isPrimitive() ? this.asTypeMirror(TypeKind.valueOf(type.getName().toUpperCase())) : this.asTypeElement(type).asType());
        return mirror;
    }

    private TypeMirror asTypeMirror(TypeKind type) {
        return type.isPrimitive() ? this.types.getPrimitiveType(type) : this.types.getNoType(type);
    }

    protected List<TypeMirror> asTypeMirrorList(Class<?> ... types) {
        return Stream.of(types).map(t -> this.asTypeMirror((Class<?>)t)).collect(Collectors.toList());
    }

    protected TypeElement getEnclosingTypeElement(Element element) {
        while (element != null && !(element instanceof TypeElement)) {
            element = element.getEnclosingElement();
        }
        return (TypeElement)element;
    }

    protected TypeElement getTypeElementFor(Element context, String name) {
        if (!name.contains(".")) {
            name = this.elements.getPackageOf(context).getQualifiedName() + "." + name;
        }
        return this.elements.getTypeElement(name);
    }

    protected ExecutableElement getConstructor(TypeElement type, List<TypeMirror> parameters) {
        Element element = ElementFilter.constructorsIn(type.getEnclosedElements()).stream().filter(this.hasSameSignatureAs(parameters)).findFirst().orElse(null);
        return (ExecutableElement)element;
    }

    protected ExecutableElement getMethod(TypeElement type, Method method) {
        Element element = ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(this.hasSameSignatureAs(method)).findFirst().orElse(null);
        return (ExecutableElement)element;
    }

    protected ExecutableElement overrides(ExecutableElement overrider) {
        TypeElement type = (TypeElement)overrider.getEnclosingElement();
        ExecutableElement element = this.types.directSupertypes(type.asType()).stream().map(t -> this.overrides(overrider, this.types.asElement((TypeMirror)t))).filter(Objects::nonNull).findFirst().orElse(null);
        return element;
    }

    private ExecutableElement overrides(ExecutableElement overrider, Element type) {
        ExecutableElement overridden = null;
        if (type != null) {
            switch (type.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    overridden = this.overridden(overrider, (TypeElement)type);
                    break;
                }
            }
        }
        return overridden;
    }

    private ExecutableElement overridden(ExecutableElement overrider, TypeElement type) {
        ExecutableElement element = ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(this.withoutModifiers(javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC)).filter(t -> this.elements.overrides(overrider, (ExecutableElement)t, type)).findFirst().orElse(null);
        if (element == null) {
            element = this.overrides(overrider, this.types.asElement(type.getSuperclass()));
        }
        return element;
    }

    protected boolean overrides(ExecutableElement overrider, ExecutableElement overridden) {
        TypeElement type = (TypeElement)overridden.getEnclosingElement();
        return this.elements.overrides(overrider, overridden, type);
    }

    protected ExecutableElement implementationOf(ExecutableElement overridden, TypeElement type) {
        ExecutableElement element = null;
        if (type != null && (element = (ExecutableElement)ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(t -> this.overrides((ExecutableElement)t, overridden)).findFirst().orElse(null)) == null) {
            element = Optional.ofNullable(type.getSuperclass()).map(t -> (TypeElement)this.types.asElement((TypeMirror)t)).filter(Objects::nonNull).map(t -> this.implementationOf(overridden, (TypeElement)t)).orElse(null);
        }
        return element;
    }

    protected ExecutableElement specifiedBy(ExecutableElement method) {
        ExecutableElement specification = this.overrides(method);
        if (specification != null) {
            ExecutableElement overridden;
            while ((overridden = this.overrides(specification)) != null) {
                specification = overridden;
            }
        }
        return specification;
    }

    protected String signature(Executable executable) {
        String signature = Stream.of(executable.getParameterTypes()).map(Class::getCanonicalName).collect(Collectors.joining(",", "(", ")"));
        return signature;
    }

    protected String signature(ExecutableElement element) {
        String signature = element.getParameters().stream().map(Element::asType).map(Object::toString).collect(Collectors.joining(",", "(", ")"));
        return signature;
    }

    protected AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> type) {
        return this.getAnnotationMirror(element, type.getName());
    }

    protected AnnotationMirror getAnnotationMirror(Element element, TypeElement type) {
        return this.getAnnotationMirror(element, type.getQualifiedName().toString());
    }

    private AnnotationMirror getAnnotationMirror(Element element, String name) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(t -> t.getAnnotationType().toString().equals(name)).map(t -> t).findFirst().orElse(null);
        return mirror;
    }

    protected AnnotationValue getAnnotationValue(AnnotationMirror annotation, String name) {
        AnnotationValue value = this.elements.getElementValuesWithDefaults(annotation).entrySet().stream().filter(t -> this.named(name).test((Element)t.getKey())).map(t -> (AnnotationValue)t.getValue()).findFirst().orElse(null);
        return value;
    }

    protected boolean isEmptyArray(AnnotationValue value) {
        List list = (List)(value != null ? value.getValue() : null);
        return list == null || list.isEmpty();
    }

    protected String getPropertyName(ExecutableElement element) {
        String string = Stream.of(PropertyMethodEnum.values()).filter(t -> t.getPropertyName(element.getSimpleName().toString()) != null).filter(t -> this.isAssignableTo(t.getReturnType(), (? super Element e) -> ((ExecutableElement)e).getReturnType()).test(element)).filter(t -> this.withParameters(t.getParameterTypes()).test(element)).map(t -> t.getPropertyName(element.getSimpleName().toString())).findFirst().orElse(null);
        return string;
    }

    protected boolean isGetterMethod(ExecutableElement element) {
        Optional<PropertyMethodEnum> optional = Stream.of(PropertyMethodEnum.GET, PropertyMethodEnum.IS).filter(t -> t.getPropertyName(element.getSimpleName().toString()) != null).filter(t -> this.withoutModifiers(javax.lang.model.element.Modifier.PRIVATE).test(element)).filter(t -> this.isAssignableTo(t.getReturnType(), (? super Element e) -> ((ExecutableElement)e).getReturnType()).test(element)).filter(t -> this.withParameters(t.getParameterTypes()).test(element)).findFirst();
        return optional.isPresent();
    }

    protected Set<String> getPropertyNames(TypeElement type) {
        return this.getPropertyNames(new TreeSet<String>(), type);
    }

    private Set<String> getPropertyNames(Set<String> set, TypeElement type) {
        for (ExecutableElement element : ElementFilter.methodsIn(type.getEnclosedElements())) {
            if (!this.withoutModifiers(javax.lang.model.element.Modifier.PRIVATE).test(element)) continue;
            Stream.of(PropertyMethodEnum.values()).filter(t -> t.getPropertyName(element.getSimpleName().toString()) != null).filter(t -> this.isAssignableTo(t.getReturnType(), (? super Element e) -> ((ExecutableElement)e).getReturnType()).test(element)).filter(t -> this.withParameters(t.getParameterTypes()).test(element)).map(t -> t.getPropertyName(element.getSimpleName().toString())).forEach(t -> set.add((String)t));
        }
        Element superclass = this.types.asElement(type.getSuperclass());
        if (superclass != null) {
            switch (superclass.getKind()) {
                case CLASS: {
                    this.getPropertyNames(set, (TypeElement)superclass);
                    break;
                }
            }
        }
        return set;
    }

    protected <E extends Enum<E>> EnumSet<E> toEnumSet(E[] array) {
        return EnumSet.copyOf(Arrays.asList(array));
    }

    private <E extends Enum<E>> Predicate<Element> is(E e, Function<? super Element, E> extractor) {
        return t -> e.equals(extractor.apply((Element)t));
    }

    protected Predicate<Element> hasSameSignatureAs(List<TypeMirror> parameters) {
        return this.is(ElementKind.CONSTRUCTOR, Element::getKind).and(this.withParameters(parameters));
    }

    protected Predicate<Element> hasSameSignatureAs(Executable executable) {
        return this.hasSameSignatureAs(executable.getName(), executable.getParameterTypes());
    }

    protected Predicate<Element> hasSameSignatureAs(CharSequence name, Class<?>[] parameters) {
        return this.is(ElementKind.METHOD, Element::getKind).and(this.named(name).and(this.withParameters(parameters)));
    }

    protected Predicate<Element> isAssignableTo(Class<?> type) {
        return this.isAssignableTo(type, (? super Element t) -> t.asType());
    }

    protected Predicate<Element> isAssignableTo(TypeMirror type) {
        return this.isAssignableTo(type, (? super Element t) -> t.asType());
    }

    protected Predicate<Element> isAssignableTo(Class<?> type, Function<? super Element, TypeMirror> extractor) {
        return this.isAssignableTo(this.asTypeMirror(type), extractor);
    }

    protected Predicate<Element> isAssignableTo(TypeMirror type, Function<? super Element, TypeMirror> extractor) {
        return t -> this.types.isAssignable((TypeMirror)extractor.apply((Element)t), type);
    }

    protected Predicate<Element> named(CharSequence name) {
        return t -> t.getSimpleName().contentEquals(name);
    }

    protected Predicate<Element> withParameters(Class<?>[] parameters) {
        return this.withParameters(this.asTypeMirrorList(parameters));
    }

    protected Predicate<Element> withParameters(final List<TypeMirror> parameters) {
        return new Predicate<Element>(){

            @Override
            public boolean test(Element element) {
                boolean match;
                boolean bl = match = parameters.size() == ((ExecutableElement)element).getParameters().size();
                if (match) {
                    match &= IntStream.range(0, parameters.size()).allMatch(i -> JavaxLangModelUtilities.this.isAssignableTo((TypeMirror)parameters.get(i), t -> JavaxLangModelUtilities.this.types.erasure(((ExecutableElement)t).getParameters().get(i).asType())).test(element));
                }
                return match;
            }
        };
    }

    protected Predicate<Element> withModifiers(javax.lang.model.element.Modifier ... modifiers) {
        return this.withModifiers(this.toEnumSet(modifiers));
    }

    protected Predicate<Element> withModifiers(Set<javax.lang.model.element.Modifier> modifiers) {
        return this.with(modifiers, t -> t.getModifiers());
    }

    protected Predicate<Element> withoutModifiers(javax.lang.model.element.Modifier ... modifiers) {
        return this.withoutModifiers(this.toEnumSet(modifiers));
    }

    protected Predicate<Element> withoutModifiers(Set<javax.lang.model.element.Modifier> modifiers) {
        return this.without(modifiers, t -> t.getModifiers());
    }

    protected <E> Predicate<Element> with(Set<E> set, Function<Element, Collection<E>> extractor) {
        return t -> ((Collection)extractor.apply((Element)t)).containsAll(set);
    }

    protected <E> Predicate<Element> without(Set<E> set, Function<Element, Collection<E>> extractor) {
        return t -> Collections.disjoint(set, (Collection)extractor.apply((Element)t));
    }

    protected ClassLoader getClassPathClassLoader(JavaFileManager fm, ClassLoader parent) {
        ClassLoader loader = parent;
        if (fm != null && (loader = fm.getClassLoader(StandardLocation.CLASS_PATH)) instanceof URLClassLoader) {
            loader = URLClassLoader.newInstance(((URLClassLoader)loader).getURLs(), parent);
        }
        return loader;
    }

    protected ClassLoader getClassPathClassLoader(JavaFileManager fm) {
        return this.getClassPathClassLoader(fm, this.getClass().getClassLoader());
    }

    public static int toModifiers(Set<javax.lang.model.element.Modifier> set) {
        return MODIFIERS.toModifiers(set);
    }

    @Generated
    protected JavaxLangModelUtilities() {
    }

    @Generated
    public String toString() {
        return "JavaxLangModelUtilities(elements=" + this.elements + ", types=" + this.types + ", fm=" + this.fm + ", loader=" + this.loader + ")";
    }

    static {
        ArrayList<Class<Annotation>> list = new ArrayList<Class<Annotation>>();
        for (String name : Arrays.asList("javax.annotation.Generated", "javax.annotation.processing.Generated")) {
            try {
                list.add(Class.forName(name).asSubclass(Annotation.class));
            }
            catch (Exception exception) {}
        }
        GENERATED_ANNOTATION_LIST = Collections.unmodifiableList(list);
    }

    private static class ModifierMap
    extends EnumMap<javax.lang.model.element.Modifier, Integer> {
        private static final long serialVersionUID = 1665841849117866554L;

        public ModifierMap() {
            super(javax.lang.model.element.Modifier.class);
            for (javax.lang.model.element.Modifier key : javax.lang.model.element.Modifier.values()) {
                try {
                    Object value = Modifier.class.getField(key.name()).get(null);
                    this.put(key, (Integer)value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public int toModifiers(Set<javax.lang.model.element.Modifier> set) {
            return set.stream().map(this::get).mapToInt(Integer::intValue).sum();
        }
    }
}

