/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.Manifest;
import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.ClassFileProcessor;
import ball.annotation.processing.For;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@For(value={Manifest.Attribute.class, Manifest.MainClass.class, Manifest.Section.class, Manifest.JavaBean.class, Manifest.DependsOn.class, Manifest.DesignTimeOnly.class})
public class ManifestProcessor
extends AnnotatedProcessor
implements ClassFileProcessor {
    private static final String PATH = "META-INF/MANIFEST.MF";
    private static final Method PROTOTYPE = PROTOTYPE.class.getDeclaredMethods()[0];

    @Override
    protected void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
        super.process(roundEnv, annotation, element);
        Manifest.Attribute attribute = element.getAnnotation(Manifest.Attribute.class);
        Manifest.MainClass main = element.getAnnotation(Manifest.MainClass.class);
        if (main != null) {
            switch (element.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    TypeElement type = (TypeElement)element;
                    ExecutableElement method = this.getMethod(type, PROTOTYPE);
                    if (method != null && method.getModifiers().containsAll(this.getModifiers(PROTOTYPE))) break;
                    this.print(Diagnostic.Kind.ERROR, element, "@%s: %s does not implement '%s'", new Object[]{main.annotationType().getSimpleName(), element.getKind(), this.declaration(PROTOTYPE)});
                    break;
                }
            }
        }
        Manifest.Section section = element.getAnnotation(Manifest.Section.class);
        Manifest.JavaBean bean = element.getAnnotation(Manifest.JavaBean.class);
        Manifest.DependsOn depends = element.getAnnotation(Manifest.DependsOn.class);
        Manifest.DesignTimeOnly design = element.getAnnotation(Manifest.DesignTimeOnly.class);
    }

    @Override
    public void process(Set<Class<?>> set, JavaFileManager fm) throws Exception {
        ManifestImpl manifest = new ManifestImpl();
        FileObject file = fm.getFileForInput(StandardLocation.CLASS_PATH, "", PATH);
        if (file != null) {
            try {
                InputStream in = file.openInputStream();
                Object object = null;
                try {
                    manifest.read(in);
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (in != null) {
                        if (object != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
            }
            catch (IOException in) {}
        } else {
            manifest.init();
        }
        file = fm.getFileForOutput(StandardLocation.CLASS_OUTPUT, "", PATH, null);
        URI root = file.toUri().resolve("..").normalize();
        for (Class clazz : set) {
            Manifest.Section section;
            URI uri = fm.getJavaFileForInput(StandardLocation.CLASS_OUTPUT, clazz.getName(), JavaFileObject.Kind.CLASS).toUri();
            uri = root.relativize(uri);
            Manifest.Attribute attribute = clazz.getAnnotation(Manifest.Attribute.class);
            Manifest.MainClass main = clazz.getAnnotation(Manifest.MainClass.class);
            if (main != null) {
                manifest.put(main, clazz.getName());
            }
            if ((section = clazz.getAnnotation(Manifest.Section.class)) != null) {
                manifest.put(uri.resolve("").toString(), section);
            }
            Manifest.JavaBean bean = clazz.getAnnotation(Manifest.JavaBean.class);
            Manifest.DependsOn depends = clazz.getAnnotation(Manifest.DependsOn.class);
            Manifest.DesignTimeOnly design = clazz.getAnnotation(Manifest.DesignTimeOnly.class);
            if (bean == null && depends == null && design == null) continue;
            manifest.put(uri.toString(), bean, depends, design);
        }
        Throwable throwable = null;
        try (OutputStream out = file.openOutputStream();){
            manifest.write(out);
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    @Generated
    public ManifestProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "ManifestProcessor()";
    }

    static {
        PROTOTYPE.setAccessible(true);
    }

    private class ManifestImpl
    extends Manifest {
        private static final String MANIFEST_VERSION = "Manifest-Version";

        protected void init() {
            if (this.getMainAttributes().getValue(MANIFEST_VERSION) == null) {
                this.getMainAttributes().putValue(MANIFEST_VERSION, "1.0");
            }
        }

        public Attributes putAttributes(String name, Attributes attributes) {
            return this.getEntries().put(name, attributes);
        }

        public String put(Manifest.MainClass main, String name) {
            return this.getMainAttributes().putValue(this.getAttributeName(main.getClass()), name);
        }

        public void put(String path, Manifest.Section section) {
            Attributes attributes = this.getEntries().get(path);
            if (attributes == null) {
                attributes = new Attributes();
                this.getEntries().put(path, attributes);
            }
            attributes.putValue("Sealed", String.valueOf(section.sealed()));
        }

        public void put(String path, Manifest.JavaBean bean, Manifest.DependsOn depends, Manifest.DesignTimeOnly design) {
            Attributes attributes = this.getEntries().get(path);
            if (attributes == null) {
                attributes = new Attributes();
                this.getEntries().put(path, attributes);
            }
            attributes.putValue(this.getAttributeName(Manifest.JavaBean.class), String.valueOf(true));
            if (depends != null) {
                attributes.putValue(this.getAttributeName(depends.getClass()), String.join((CharSequence)" ", depends.value()));
            }
            if (design != null) {
                attributes.putValue(this.getAttributeName(design.getClass()), String.join((CharSequence)" ", design.value()));
            }
        }

        private String getAttributeName(Class<? extends Annotation> type) {
            return type.getAnnotation(Manifest.Attribute.class).value();
        }

        @Generated
        public ManifestImpl() {
        }

        @Generated
        public String toString() {
            return "ManifestProcessor.ManifestImpl()";
        }
    }

    private static abstract class PROTOTYPE {
        private PROTOTYPE() {
        }

        public static void main(String[] argv) {
        }
    }
}

