/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.MatcherGroup;
import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.For;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@For(value={MatcherGroup.class})
public class MatcherGroupProcessor
extends AnnotatedProcessor {
    @Override
    protected void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
        super.process(roundEnv, annotation, element);
        AnnotationMirror mirror = this.getAnnotationMirror(element, annotation);
        AnnotationValue value = this.getAnnotationValue(mirror, "value");
        int group = (Integer)value.getValue();
        if (group < 0) {
            this.print(Diagnostic.Kind.ERROR, element, mirror, value, "value() must be non-negative", new Object[0]);
        }
        switch (element.getKind()) {
            default: {
                break;
            }
            case METHOD: {
                ExecutableElement executable = (ExecutableElement)element;
                if (this.withoutModifiers(Modifier.PRIVATE).test(element)) {
                    if (!executable.isVarArgs() && executable.getParameters().size() == 1) break;
                    this.print(Diagnostic.Kind.ERROR, element, "@%s: %s must take exactly one argument", new Object[]{annotation.getSimpleName(), element.getKind()});
                    break;
                }
                this.print(Diagnostic.Kind.ERROR, element, "@%s: %s is %s", new Object[]{annotation.getSimpleName(), element.getKind(), Modifier.PRIVATE});
            }
        }
    }

    @Generated
    public MatcherGroupProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "MatcherGroupProcessor()";
    }
}

