/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedNoAnnotationProcessor;
import ball.annotation.processing.ForElementKinds;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@ForElementKinds(value={ElementKind.METHOD})
public class ObjectCloneProcessor
extends AnnotatedNoAnnotationProcessor {
    private static final Method PROTOTYPE;
    private ExecutableElement METHOD = null;
    private TypeElement CLONEABLE = null;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        try {
            this.METHOD = this.asExecutableElement(PROTOTYPE);
            this.CLONEABLE = this.asTypeElement(Cloneable.class);
            this.criteria.add(t -> this.overrides((ExecutableElement)t, this.METHOD));
        }
        catch (Exception exception) {
            this.print(Diagnostic.Kind.ERROR, exception);
        }
    }

    @Override
    protected void process(RoundEnvironment roundEnv, Element element) {
        if (!this.isGenerated(element)) {
            ExecutableElement method = (ExecutableElement)element;
            TypeElement type = (TypeElement)method.getEnclosingElement();
            if (!type.getInterfaces().contains(this.CLONEABLE.asType())) {
                this.print(Diagnostic.Kind.WARNING, (Element)type, "%s overrides '%s' but does not implement %s", new Object[]{type.getKind(), this.declaration(PROTOTYPE), this.CLONEABLE.getSimpleName()});
            }
            if (!this.types.isAssignable(method.getReturnType(), type.asType())) {
                this.print(Diagnostic.Kind.WARNING, (Element)method, "%s overrides '%s' but does not return a subclass of %s", new Object[]{method.getKind(), this.declaration(PROTOTYPE), type.getSimpleName()});
            }
            List throwables = this.METHOD.getThrownTypes().stream().collect(Collectors.toList());
            throwables.retainAll(this.overrides(method).getThrownTypes());
            throwables.removeAll(method.getThrownTypes());
            throwables.stream().map(t -> this.types.asElement((TypeMirror)t)).map(t -> t.getSimpleName()).forEach(t -> this.print(Diagnostic.Kind.WARNING, (Element)method, "%s overrides '%s' but does not throw %s", new Object[]{method.getKind(), this.declaration(PROTOTYPE), t}));
        }
    }

    @Generated
    public ObjectCloneProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "ObjectCloneProcessor(METHOD=" + this.METHOD + ", CLONEABLE=" + this.CLONEABLE + ")";
    }

    static {
        try {
            PROTOTYPE = Object.class.getDeclaredMethod("clone", new Class[0]);
            PROTOTYPE.setAccessible(true);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }
}

