/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedNoAnnotationProcessor;
import ball.annotation.processing.ForElementKinds;
import ball.annotation.processing.ForSubclassesOf;
import ball.annotation.processing.WithoutModifiers;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@ForElementKinds(value={ElementKind.CLASS})
@ForSubclassesOf(value=Object.class)
@WithoutModifiers(value={Modifier.ABSTRACT})
public class ObjectToStringProcessor
extends AnnotatedNoAnnotationProcessor {
    private static final Method PROTOTYPE;
    private static final Set<String> ANNOTATIONS;
    private ExecutableElement METHOD = null;

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        try {
            this.METHOD = this.asExecutableElement(PROTOTYPE);
        }
        catch (Exception exception) {
            this.print(Diagnostic.Kind.ERROR, exception);
        }
    }

    @Override
    protected void process(RoundEnvironment roundEnv, Element element) {
        ExecutableElement implementation;
        TypeElement type;
        if (!(this.isGenerated(element) || this.isAnnotated(type = (TypeElement)element) || (implementation = this.implementationOf(this.METHOD, type)) != null && !this.METHOD.equals(implementation))) {
            this.print(Diagnostic.Kind.WARNING, (Element)type, "%s does not override '%s'", new Object[]{type.getKind(), this.declaration(PROTOTYPE)});
        }
    }

    private boolean isAnnotated(TypeElement element) {
        TypeMirror mirror;
        boolean found = element.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(Objects::toString).anyMatch(ANNOTATIONS::contains);
        if (!found && (mirror = element.getSuperclass()) != null && !mirror.getKind().equals((Object)TypeKind.NONE)) {
            found |= this.isAnnotated((TypeElement)this.types.asElement(mirror));
        }
        return found;
    }

    @Generated
    public ObjectToStringProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "ObjectToStringProcessor(METHOD=" + this.METHOD + ")";
    }

    static {
        try {
            PROTOTYPE = Object.class.getDeclaredMethod("toString", new Class[0]);
            PROTOTYPE.setAccessible(true);
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
        ANNOTATIONS = ResourceBundle.getBundle(ObjectToStringProcessor.class.getName()).keySet();
    }
}

