/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedNoAnnotationProcessor;
import ball.annotation.processing.ForElementKinds;
import ball.annotation.processing.ForSubclassesOf;
import ball.tools.javac.AbstractTaskListener;
import com.sun.source.util.TaskEvent;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@ForElementKinds(value={ElementKind.CLASS})
@ForSubclassesOf(value=Serializable.class)
public class SerializableProcessor
extends AnnotatedNoAnnotationProcessor {
    private static final Field PROTOTYPE = PROTOTYPE.class.getDeclaredFields()[0];
    private final Set<TypeElement> set = new TreeSet<TypeElement>(Comparator.comparing(t -> t.getQualifiedName().toString()));

    @Override
    protected void whenAnnotationProcessingFinished() {
        this.javac.addTaskListener(new TaskListenerImpl());
    }

    @Override
    protected void process(RoundEnvironment roundEnv, Element element) {
        TypeElement type;
        VariableElement field;
        if (!(this.isGenerated(element) || (field = (VariableElement)ElementFilter.fieldsIn((type = (TypeElement)element).getEnclosedElements()).stream().filter(t -> t.getSimpleName().contentEquals(PROTOTYPE.getName())).findFirst().orElse(null)) != null && field.getModifiers().containsAll(this.getModifiers(PROTOTYPE)) && this.isAssignableTo(PROTOTYPE.getType()).test(field))) {
            this.set.add(type);
        }
    }

    @Generated
    public SerializableProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "SerializableProcessor(set=" + this.set + ")";
    }

    static {
        PROTOTYPE.setAccessible(true);
    }

    private class TaskListenerImpl
    extends AbstractTaskListener {
        @Override
        public void finished(TaskEvent event) {
            switch (event.getKind()) {
                case GENERATE: {
                    ClassLoader loader = SerializableProcessor.this.getClassPathClassLoader(SerializableProcessor.this.fm);
                    Iterator iterator = SerializableProcessor.this.set.iterator();
                    while (iterator.hasNext()) {
                        TypeElement type = (TypeElement)iterator.next();
                        String name = SerializableProcessor.this.elements.getBinaryName(type).toString();
                        try {
                            Class<?> cls = Class.forName(name, true, loader);
                            long uid = ObjectStreamClass.lookup(cls).getSerialVersionUID();
                            SerializableProcessor.this.print(Diagnostic.Kind.WARNING, (Element)type, "%s %s has no definition of %s\n%s = %dL;", new Object[]{SerializableProcessor.this.getForSubclassesOf().getSimpleName(), type.getKind(), PROTOTYPE.getName(), SerializableProcessor.this.declaration(PROTOTYPE), uid});
                            iterator.remove();
                        }
                        catch (ClassNotFoundException exception) {
                        }
                        catch (NoClassDefFoundError error) {
                        }
                        catch (Throwable throwable) {}
                    }
                    break;
                }
            }
        }

        @Generated
        public TaskListenerImpl() {
        }

        @Override
        @Generated
        public String toString() {
            return "SerializableProcessor.TaskListenerImpl()";
        }
    }

    private static abstract class PROTOTYPE {
        private static final long serialVersionUID = 0L;

        private PROTOTYPE() {
        }
    }
}

