/*
 * Decompiled with CFR 0.152.
 */
package ball.annotation.processing;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.ClassFileProcessor;
import ball.annotation.processing.For;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import lombok.Generated;

@ServiceProviderFor(value={Processor.class})
@For(value={ServiceProviderFor.class})
public class ServiceProviderForProcessor
extends AnnotatedProcessor
implements ClassFileProcessor {
    private static final Method PROTOTYPE = PROTOTYPE.class.getDeclaredMethods()[0];
    private static final String PATH = "META-INF/services/%s";
    private final Map<String, Set<String>> map = new TreeMap<String, Set<String>>();

    @Override
    protected void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
        super.process(roundEnv, annotation, element);
        TypeElement type = (TypeElement)element;
        AnnotationMirror mirror = this.getAnnotationMirror((Element)type, annotation);
        AnnotationValue value = this.getAnnotationValue(mirror, "value");
        if (!this.isEmptyArray(value)) {
            ExecutableElement method = this.getMethod(type, PROTOTYPE);
            if (method != null) {
                if (!method.getModifiers().containsAll(this.getModifiers(PROTOTYPE))) {
                    this.print(Diagnostic.Kind.ERROR, (Element)method, "@%s: %s is not %s", new Object[]{annotation.getSimpleName(), method.getKind(), this.modifiers(PROTOTYPE.getModifiers())});
                }
            } else {
                ExecutableElement constructor;
                boolean found;
                if (!this.withoutModifiers(Modifier.ABSTRACT).test(element)) {
                    this.print(Diagnostic.Kind.ERROR, element, "%s: %s must not be %s", new Object[]{annotation.getSimpleName(), element.getKind(), Modifier.ABSTRACT});
                }
                boolean bl = found = (constructor = this.getConstructor((TypeElement)element, Collections.emptyList())) != null && constructor.getModifiers().contains((Object)Modifier.PUBLIC);
                if (!found) {
                    this.print(Diagnostic.Kind.ERROR, element, "@%s: No %s NO-ARG constructor", new Object[]{annotation.getSimpleName(), Modifier.PUBLIC});
                }
            }
            String provider = this.elements.getBinaryName(type).toString();
            List services = Stream.of(value).filter(Objects::nonNull).map(t -> (List)t.getValue()).flatMap(Collection::stream).map(t -> (AnnotationValue)t).map(t -> t.getValue()).filter(t -> t instanceof TypeMirror).map(t -> (TypeElement)this.types.asElement((TypeMirror)t)).collect(Collectors.toList());
            for (TypeElement service : services) {
                if (this.isAssignable(type, service)) {
                    if (method == null || this.isAssignable(method.getReturnType(), service.asType())) {
                        this.map.computeIfAbsent(service.getQualifiedName().toString(), k -> new TreeSet()).add(provider);
                        continue;
                    }
                    this.print(Diagnostic.Kind.ERROR, (Element)method, "@%s: %s does not return %s", new Object[]{annotation.getSimpleName(), method.getKind(), service.getQualifiedName()});
                    continue;
                }
                this.print(Diagnostic.Kind.ERROR, (Element)type, "@%s: %s does not implement %s", new Object[]{annotation.getSimpleName(), type.getKind(), service.getQualifiedName()});
            }
        } else {
            this.print(Diagnostic.Kind.ERROR, (Element)type, mirror, value, "value() is empty", new Object[0]);
        }
    }

    private boolean isAssignable(Element from, Element to) {
        return this.isAssignable(from.asType(), to.asType());
    }

    private boolean isAssignable(TypeMirror from, TypeMirror to) {
        return this.types.isAssignable(this.types.erasure(from), this.types.erasure(to));
    }

    @Override
    public void process(Set<Class<?>> set, JavaFileManager fm) throws Exception {
        if (this.map.isEmpty()) {
            for (Class clazz : set) {
                ServiceProviderFor annotation = clazz.getAnnotation(ServiceProviderFor.class);
                if (annotation == null) continue;
                for (Class<?> service : annotation.value()) {
                    if (!service.isAssignableFrom(clazz)) continue;
                    this.map.computeIfAbsent(service.getName(), k -> new TreeSet()).add(clazz.getName());
                }
            }
        }
        for (Map.Entry entry : this.map.entrySet()) {
            String service = (String)entry.getKey();
            FileObject file = fm.getFileForOutput(StandardLocation.CLASS_OUTPUT, "", String.format(PATH, service), null);
            PrintWriter writer = new PrintWriter(file.openWriter());
            Throwable throwable = null;
            try {
                writer.println("# " + service);
                ((Set)entry.getValue()).stream().forEach(t -> writer.println((String)t));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (writer == null) continue;
                if (throwable != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                writer.close();
            }
        }
    }

    @Generated
    public ServiceProviderForProcessor() {
    }

    @Override
    @Generated
    public String toString() {
        return "ServiceProviderForProcessor(map=" + this.map + ")";
    }

    static {
        PROTOTYPE.setAccessible(true);
    }

    private static abstract class PROTOTYPE {
        private PROTOTYPE() {
        }

        public static Object provider() {
            return null;
        }
    }
}

