/*
 * Decompiled with CFR 0.152.
 */
package ball.beans;

import ball.annotation.ConstantValueMustConvertTo;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum PropertyMethodEnum {
    GET,
    IS,
    SET;

    private static final Map<PropertyMethodEnum, Method> MAP;
    @ConstantValueMustConvertTo(value=Pattern.class, method="compile")
    private static final String PROPERTY_REGEX = "([\\p{Upper}][\\p{Alnum}]*)";
    private Pattern pattern = null;

    public Class<?> getReturnType() {
        return MAP.get((Object)this).getReturnType();
    }

    public Class<?>[] getParameterTypes() {
        return MAP.get((Object)this).getParameterTypes();
    }

    public String getPropertyName(String method) {
        Matcher matcher;
        String name = null;
        if (method != null && (matcher = this.pattern().matcher(method)).matches()) {
            name = Introspector.decapitalize(matcher.group(1));
        }
        return name;
    }

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(Pattern.quote(this.name().toLowerCase()) + PROPERTY_REGEX);
        }
        return this.pattern;
    }

    public static String getPropertyName(Method method) {
        String name = null;
        if (method != null) {
            PropertyMethodEnum methodEnum;
            PropertyMethodEnum[] propertyMethodEnumArray = PropertyMethodEnum.values();
            int n = propertyMethodEnumArray.length;
            for (int i = 0; i < n && (name = (methodEnum = propertyMethodEnumArray[i]).getPropertyName(method.getName())) == null; ++i) {
            }
        }
        return name;
    }

    static {
        MAP = Collections.unmodifiableMap(new MethodPrototypeMap());
    }

    private static class MethodPrototypeMap
    extends EnumMap<PropertyMethodEnum, Method> {
        private static final long serialVersionUID = 6408568606272721794L;

        public MethodPrototypeMap() {
            super(PropertyMethodEnum.class);
            for (Method method : Prototypes.class.getDeclaredMethods()) {
                this.put(PropertyMethodEnum.valueOf(method.getName()), method);
            }
        }

        public static interface Prototypes<T> {
            public T GET();

            public boolean IS();

            public void SET(T var1);
        }
    }
}

