/*
 * Decompiled with CFR 0.152.
 */
package ball.io;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class BOMCharsetMap
extends LinkedHashMap<byte[], Charset> {
    private static final long serialVersionUID = -4968264081542792700L;
    public static final Map<byte[], Charset> INSTANCE = Collections.unmodifiableMap(new BOMCharsetMap());

    protected BOMCharsetMap() {
        this.put(BOMCharsetMap.bytes(0, 0, 254, 255), Charset.forName("UTF-32BE"));
        this.put(BOMCharsetMap.bytes(255, 254, 0, 0), Charset.forName("UTF-32LE"));
        this.put(BOMCharsetMap.bytes(239, 187, 191), StandardCharsets.UTF_8);
        this.put(BOMCharsetMap.bytes(254, 255), StandardCharsets.UTF_16BE);
        this.put(BOMCharsetMap.bytes(255, 254), StandardCharsets.UTF_16LE);
    }

    private static byte[] bytes(int ... elements) {
        byte[] bytes = new byte[elements.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(elements[i] & 0xFF);
        }
        return bytes;
    }

    @Override
    public String toString() {
        String string = this.entrySet().stream().map(t -> this.toString((byte[])t.getKey()) + "=" + this.toString((Charset)t.getValue())).collect(Collectors.joining(", ", "{", "}"));
        return string;
    }

    private String toString(byte[] bytes) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        for (int i = 0; i < bytes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(String.format("0x%02X", bytes[i]));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private String toString(Charset charset) {
        return charset != null ? charset.name() : null;
    }
}

