/*
 * Decompiled with CFR 0.152.
 */
package ball.io;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Objects;
import lombok.Generated;

public class CharSequenceReader
extends LineNumberReader {
    public CharSequenceReader(CharSequence sequence) {
        super(new ReaderImpl(sequence), 1024);
    }

    @Generated
    public String toString() {
        return "CharSequenceReader()";
    }

    private static class ReaderImpl
    extends Reader {
        private CharSequence sequence = null;
        private volatile int length = 0;
        private volatile int pos = 0;
        private volatile int mark = 0;

        public ReaderImpl(CharSequence sequence) {
            super(new Object());
            this.sequence = Objects.requireNonNull(sequence);
            this.length = sequence.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            int character = -1;
            Object object = this.lock;
            synchronized (object) {
                if (this.pos < this.length) {
                    character = this.sequence.charAt(this.pos++);
                }
            }
            return character;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(char[] chars, int off, int len) throws IOException {
            int count = -1;
            Object object = this.lock;
            synchronized (object) {
                if (this.pos < this.length) {
                    count = Math.min(this.length - this.pos, len);
                    for (int i = 0; i < count; ++i) {
                        chars[off + i] = this.sequence.charAt(this.pos + i);
                    }
                    this.pos += count;
                }
            }
            return count;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long skip(long count) throws IOException {
            if (count < 0L) {
                throw new IllegalArgumentException("skip value is negative");
            }
            Object object = this.lock;
            synchronized (object) {
                count = Math.min(count, (long)(this.length - this.pos));
                this.pos = (int)((long)this.pos + count);
            }
            return count;
        }

        @Override
        public boolean ready() throws IOException {
            return true;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mark(int readAheadLimit) throws IOException {
            if (readAheadLimit < 0) {
                throw new IllegalArgumentException("Read-ahead limit < 0");
            }
            Object object = this.lock;
            synchronized (object) {
                this.mark = this.pos;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.pos = this.mark;
            }
        }

        @Override
        public void close() throws IOException {
            this.sequence = null;
        }

        @Generated
        public String toString() {
            return "CharSequenceReader.ReaderImpl(sequence=" + this.sequence + ", length=" + this.length + ", pos=" + this.pos + ", mark=" + this.mark + ")";
        }
    }
}

