/*
 * Decompiled with CFR 0.152.
 */
package ball.io;

import ball.io.BOMCharsetMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class UnicodeReader
extends LineNumberReader {
    private static final Charset DEFAULT = StandardCharsets.UTF_8;

    public UnicodeReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file));
    }

    public UnicodeReader(InputStream in) {
        this(in instanceof CharsetDetectInputStream ? (CharsetDetectInputStream)in : new CharsetDetectInputStream(in, DEFAULT));
    }

    private UnicodeReader(CharsetDetectInputStream in) {
        super(new InputStreamReader((InputStream)in, in.getCharset()));
    }

    public String toString() {
        return super.toString();
    }

    private static class CharsetDetectInputStream
    extends PushbackInputStream {
        private final Charset charset;

        public CharsetDetectInputStream(InputStream in, Charset charset) {
            super(in, 8);
            try {
                Map.Entry<byte[], Charset> entry;
                byte[] bytes;
                int length;
                Iterator<Map.Entry<byte[], Charset>> iterator = BOMCharsetMap.INSTANCE.entrySet().iterator();
                while (iterator.hasNext() && (length = this.read(bytes = new byte[(entry = iterator.next()).getKey().length])) >= 0) {
                    if (bytes.length == length && Arrays.equals(bytes, entry.getKey())) {
                        charset = entry.getValue();
                        break;
                    }
                    if (length <= 0) continue;
                    this.unread(bytes, 0, length);
                }
                this.charset = Objects.requireNonNull(charset);
            }
            catch (Exception exception) {
                throw new ExceptionInInitializerError(exception);
            }
        }

        public Charset getCharset() {
            return this.charset;
        }

        @Generated
        public String toString() {
            return "UnicodeReader.CharsetDetectInputStream(charset=" + this.getCharset() + ")";
        }
    }
}

