/*
 * Decompiled with CFR 0.152.
 */
package ball.lang.reflect;

import ball.lang.reflect.DefaultInvocationHandler;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.IdentityHashMap;
import lombok.Generated;

public abstract class FacadeProxyInvocationHandler
extends DefaultInvocationHandler {
    private final ProxyMap map = new ProxyMap();

    public Object enhance(Object in) {
        Class<?> type;
        Object out = null;
        if (!this.hasFacade(in) && (type = this.getProxyClassFor(in)) != null) {
            out = this.map.computeIfAbsent(in, k -> this.compute(type));
        }
        return out != null ? out : in;
    }

    private <T> T compute(Class<T> type) {
        T proxy = null;
        try {
            proxy = type.getConstructor(InvocationHandler.class).newInstance(this);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        return proxy;
    }

    protected abstract Class<?> getProxyClassFor(Object var1);

    private boolean hasFacade(Object object) {
        return this.reverseOf(object) != null;
    }

    private Object reverseOf(Object in) {
        InvocationHandler handler;
        Object out = null;
        if (in instanceof Proxy && Proxy.isProxyClass(in.getClass()) && (handler = Proxy.getInvocationHandler(in)) instanceof FacadeProxyInvocationHandler) {
            out = ((FacadeProxyInvocationHandler)handler).map.reverse().get(in);
        }
        return out;
    }

    private Object reverseFor(Class<?> type, Object in) {
        Object object;
        Object out = null;
        if (out == null && (object = this.reverseOf(in)) != null && type.isAssignableFrom(object.getClass())) {
            out = object;
        }
        if (out == null && in instanceof Object[] && type.isArray()) {
            int length = ((Object[])in).length;
            out = Array.newInstance(type.getComponentType(), length);
            for (int i = 0; i < length; ++i) {
                ((Object[])out)[i] = this.reverseFor(type.getComponentType(), ((Object[])in)[i]);
            }
        }
        return out != null ? out : in;
    }

    private Object[] reverseFor(Class<?>[] types, Object[] in) {
        Object[] out = null;
        if (in != null) {
            out = new Object[in.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = this.reverseFor(types[i], in[i]);
            }
        }
        return out != null ? out : in;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] argv) throws Throwable {
        Object result = null;
        Class<Object> declarer = method.getDeclaringClass();
        Object that = this.map.reverse.get(proxy);
        if (declarer.isAssignableFrom(Object.class)) {
            result = method.invoke(that, argv);
        } else {
            argv = this.reverseFor(method.getParameterTypes(), argv);
            result = declarer.isAssignableFrom(that.getClass()) ? method.invoke(that, argv) : super.invoke(proxy, method, argv);
        }
        return this.enhance(result);
    }

    @Generated
    protected FacadeProxyInvocationHandler() {
    }

    @Override
    @Generated
    public String toString() {
        return "FacadeProxyInvocationHandler(map=" + this.map + ")";
    }

    private class ProxyMap
    extends IdentityHashMap<Object, Object> {
        private static final long serialVersionUID = 6708505296087349421L;
        private final IdentityHashMap<Object, Object> reverse = new IdentityHashMap();

        public IdentityHashMap<Object, Object> reverse() {
            return this.reverse;
        }

        @Override
        public Object put(Object key, Object value) {
            this.reverse().put(value, key);
            return super.put(key, value);
        }

        @Generated
        public ProxyMap() {
        }
    }
}

