/*
 * Decompiled with CFR 0.152.
 */
package ball.lang.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public interface JavaLangReflectMethods {
    default public EnumSet<Modifier> asModifierSet(int modifiers) {
        EnumSet<Modifier> set = EnumSet.noneOf(Modifier.class);
        Stream.of(java.lang.reflect.Modifier.toString(modifiers).split("[\\p{Space}]+")).filter(t -> !t.isEmpty()).map(String::toUpperCase).map(Modifier::valueOf).forEach(set::add);
        return set;
    }

    default public EnumSet<Modifier> getModifiers(Class<?> type) {
        return this.asModifierSet(type.getModifiers());
    }

    default public EnumSet<Modifier> getModifiers(Member member) {
        return this.asModifierSet(member.getModifiers());
    }

    default public String declaration(Member member) {
        String string = null;
        if (member instanceof Constructor) {
            string = this.declaration((Constructor)member);
        } else if (member instanceof Field) {
            string = this.declaration((Field)member);
        } else if (member instanceof Method) {
            string = this.declaration((Method)member);
        } else {
            throw new IllegalArgumentException(String.valueOf(member));
        }
        return string;
    }

    default public String declaration(Constructor<?> constructor) {
        String string = this.modifiers(constructor.getModifiers()) + " " + constructor.getName() + this.parameters(constructor.getParameters()) + " " + this.exceptions(constructor.getGenericExceptionTypes());
        return string.trim();
    }

    default public String declaration(Field field) {
        String string = this.modifiers(field.getModifiers()) + " " + this.type(field.getGenericType()) + " " + field.getName();
        return string.trim();
    }

    default public String declaration(Method method) {
        return this.declaration(method.getModifiers(), method);
    }

    default public String declaration(int modifiers, Method method) {
        return this.declaration(modifiers, method.getGenericReturnType(), method);
    }

    default public String declaration(int modifiers, Type returnType, Method method) {
        return this.declaration(modifiers, this.type(returnType), method);
    }

    default public String declaration(int modifiers, String returnType, Method method) {
        String string = this.modifiers(modifiers) + " " + returnType + " " + method.getName() + this.parameters(method.getParameters()) + " " + this.exceptions(method.getGenericExceptionTypes());
        return string.trim();
    }

    default public String parameters(Parameter[] parameters) {
        return Stream.of(parameters).map(t -> this.declaration((Parameter)t)).collect(Collectors.joining(", ", "(", ")"));
    }

    default public String exceptions(Type[] exceptions) {
        String string = "";
        if (exceptions != null && exceptions.length > 0) {
            string = Stream.of(exceptions).map(t -> this.type((Type)t)).collect(Collectors.joining(", ", "throws ", ""));
        }
        return string;
    }

    default public String declaration(Parameter parameter) {
        String string = this.modifiers(parameter.getModifiers()) + " " + this.type(parameter.getParameterizedType()) + " " + parameter.getName();
        return string.trim();
    }

    default public String modifiers(int modifiers) {
        return java.lang.reflect.Modifier.toString(modifiers);
    }

    default public String type(Type type) {
        String string = null;
        string = type instanceof ParameterizedType ? this.type((ParameterizedType)type) : (type instanceof Class ? ((Class)type).getSimpleName() : type.getTypeName());
        return string;
    }

    default public String type(ParameterizedType type) {
        return Stream.of(type.getActualTypeArguments()).map(t -> this.type((Type)t)).collect(Collectors.joining(",", this.type(type.getRawType()) + "<", ">"));
    }
}

