/*
 * Decompiled with CFR 0.152.
 */
package ball.text;

import ball.activation.ReaderWriterDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class TextTable
extends ReaderWriterDataSource {
    private final TableModel model;
    private int[] tabs = new int[0];
    private int[] widths = new int[0];

    public TextTable(TableModel model, int ... tabs) {
        super(null, "text/plain");
        this.model = model;
        this.getModel().addTableModelListener(new ModelListenerImpl());
    }

    public TableModel getModel() {
        return this.model;
    }

    protected void render() {
        TableModel model = this.getModel();
        if (model instanceof AbstractTableModel) {
            ((AbstractTableModel)model).fireTableDataChanged();
        }
        this.tabs = Arrays.copyOf(this.tabs, model.getColumnCount());
        this.widths = Arrays.copyOf(this.widths, model.getColumnCount());
        for (int x = 0; x < this.widths.length; ++x) {
            this.widths[x] = TextTable.length(model.getColumnName(x));
            int n = model.getRowCount();
            for (int y = 0; y < n; ++y) {
                Object object = model.getValueAt(y, x);
                String string = object != null ? object.toString() : null;
                this.widths[x] = Math.max(this.widths[x], TextTable.length(string));
            }
        }
        try (PrintWriter out = this.getPrintWriter();){
            StringBuilder header = this.line(this.fill(this.header()));
            if (!StringUtils.isBlank(header)) {
                out.println(StringUtils.stripEnd(header.toString(), null));
                out.println(StringUtils.repeat('-', header.length()));
            }
            int n = model.getRowCount();
            for (int y = 0; y < n; ++y) {
                out.println(StringUtils.stripEnd(this.line(this.fill(this.format(this.row(y)))).toString(), null));
            }
        }
        catch (IOException exception) {
            throw new IllegalStateException(exception);
        }
    }

    private String[] header() {
        String[] header = new String[this.getModel().getColumnCount()];
        for (int x = 0; x < header.length; ++x) {
            String string = this.getModel().getColumnName(x);
            header[x] = string != null ? string : "";
        }
        return header;
    }

    private Object[] row(int y) {
        Object[] row = new Object[this.getModel().getColumnCount()];
        for (int x = 0; x < row.length; ++x) {
            row[x] = this.getModel().getValueAt(y, x);
        }
        return row;
    }

    private String[] format(Object ... row) {
        String[] strings = new String[row.length];
        for (int x = 0; x < strings.length; ++x) {
            strings[x] = String.valueOf(row[x]);
        }
        return strings;
    }

    private String[] fill(String ... row) {
        String[] strings = new String[row.length];
        for (int x = 0; x < strings.length; ++x) {
            strings[x] = StringUtils.rightPad(row[x], this.widths[x], " ");
        }
        return strings;
    }

    private StringBuilder line(String[] row) {
        StringBuilder line = new StringBuilder();
        for (int x = 0; x < row.length; ++x) {
            if (x > 0) {
                line.append(" ");
            }
            while (line.length() < this.tabs[x]) {
                line.append(" ");
            }
            line.append(row[x]);
        }
        return line;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.length() <= 0L) {
            this.render();
        }
        return super.getInputStream();
    }

    private static int length(CharSequence sequence) {
        return sequence != null ? sequence.length() : 0;
    }

    private class ModelListenerImpl
    implements TableModelListener {
        @Override
        public void tableChanged(TableModelEvent event) {
            TextTable.this.clear();
        }

        @Generated
        public ModelListenerImpl() {
        }

        @Generated
        public String toString() {
            return "TextTable.ModelListenerImpl()";
        }
    }
}

