/*
 * Decompiled with CFR 0.152.
 */
package ball.tools.javadoc;

import ball.annotation.processing.JavaxLangModelUtilities;
import ball.tools.javadoc.AnnotatedTaglet;
import ball.tools.javadoc.JavadocHTMLTemplates;
import ball.xml.FluentDocument;
import ball.xml.FluentDocumentBuilderFactory;
import ball.xml.FluentNode;
import ball.xml.XalanConstants;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.DocLink;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.w3c.dom.Node;

public abstract class AbstractTaglet
extends JavaxLangModelUtilities
implements AnnotatedTaglet,
JavadocHTMLTemplates,
XalanConstants {
    private final boolean isInlineTag;
    private final boolean inPackage;
    private final boolean inOverview;
    private final boolean inField;
    private final boolean inConstructor;
    private final boolean inMethod;
    private final boolean inType;
    private final Transformer transformer;
    private final FluentDocument document;
    private Configuration configuration = null;
    private transient ClassLoader loader = null;
    private transient Method href = null;

    protected static void register(Map<Object, Object> map, AbstractTaglet taglet) {
        map.putIfAbsent(taglet.getName(), taglet);
    }

    protected AbstractTaglet(boolean isInlineTag, boolean inPackage, boolean inOverview, boolean inField, boolean inConstructor, boolean inMethod, boolean inType) {
        this.isInlineTag = isInlineTag;
        this.inPackage = isInlineTag | inPackage;
        this.inOverview = isInlineTag | inOverview;
        this.inField = isInlineTag | inField;
        this.inConstructor = isInlineTag | inConstructor;
        this.inMethod = isInlineTag | inMethod;
        this.inType = isInlineTag | inType;
        try {
            this.transformer = TransformerFactory.newInstance().newTransformer();
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
            this.transformer.setOutputProperty("indent", "no");
            this.document = FluentDocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            this.document.add(this.element("html", new Node[]{this.element("head", new Node[]{this.element("meta", new Node[]{this.attr("charset", "utf-8")})}), this.element("body", new Node[0])}));
        }
        catch (Exception exception) {
            throw new ExceptionInInitializerError(exception);
        }
    }

    @Override
    public String getName() {
        String name = AnnotatedTaglet.super.getName();
        if (name == null) {
            name = this.getClass().getSimpleName().toLowerCase();
        }
        return name;
    }

    public boolean isInlineTag() {
        return this.isInlineTag;
    }

    public boolean inPackage() {
        return this.inPackage;
    }

    public boolean inOverview() {
        return this.inOverview;
    }

    public boolean inField() {
        return this.inField;
    }

    public boolean inConstructor() {
        return this.inConstructor;
    }

    public boolean inMethod() {
        return this.inMethod;
    }

    public boolean inType() {
        return this.inType;
    }

    @Override
    public FluentDocument document() {
        return this.document;
    }

    public String toString(Tag[] tags) throws IllegalStateException {
        throw new IllegalStateException();
    }

    public String toString(Tag tag) throws IllegalStateException {
        Node node = null;
        try {
            node = this.toNode(tag);
        }
        catch (IllegalStateException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            System.err.println(tag.position() + ": " + throwable);
            node = this.toNode(tag, throwable);
        }
        return this.render(node);
    }

    public void set(Configuration configuration) {
        this.configuration = configuration;
        this.fm = configuration.getFileManager();
    }

    protected abstract Node toNode(Tag var1) throws Throwable;

    private FluentNode toNode(Tag tag, Throwable throwable) {
        String string = "@" + this.getName();
        if (StringUtils.isNotEmpty(tag.text())) {
            string = string + " " + tag.text();
        }
        if (this.isInlineTag()) {
            string = "{" + string + "}";
        }
        return this.fragment(new Node[]{this.p(new Node[]{this.b(this.u(string))}), this.comment(ExceptionUtils.getStackTrace(throwable))});
    }

    protected String render(Node node) {
        return this.render(node, 0);
    }

    protected String render(Node node, int indent) {
        StringWriter writer = new StringWriter();
        try {
            this.transformer.setOutputProperty("indent", indent > 0 ? "yes" : "no");
            this.transformer.setOutputProperty(XALAN_INDENT_AMOUNT.toString(), String.valueOf(indent > 0 ? indent : 0));
            this.transformer.transform(new DOMSource(node), new StreamResult(writer));
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return writer.toString();
    }

    protected ClassDoc containingClass(Tag tag) {
        return this.containingClass(tag.holder());
    }

    private ClassDoc containingClass(Doc holder) {
        ClassDoc doc = null;
        if (holder instanceof ClassDoc) {
            doc = (ClassDoc)holder;
        } else if (holder instanceof ProgramElementDoc) {
            doc = ((ProgramElementDoc)holder).containingClass();
        }
        return doc;
    }

    protected PackageDoc containingPackage(Tag tag) {
        return this.containingPackage(tag.holder());
    }

    private PackageDoc containingPackage(Doc holder) {
        PackageDoc doc = null;
        if (holder instanceof PackageDoc) {
            doc = (PackageDoc)holder;
        } else if (holder instanceof ProgramElementDoc) {
            doc = ((ProgramElementDoc)holder).containingPackage();
        }
        return doc;
    }

    protected ClassDoc getClassDocFor(Tag tag, String name) {
        return this.findClass(tag.holder(), name);
    }

    private ClassDoc findClass(Doc holder, String name) {
        ClassDoc doc = null;
        if (holder instanceof ClassDoc) {
            doc = this.findClass((ClassDoc)holder, name);
        } else if (holder instanceof PackageDoc) {
            doc = this.findClass((PackageDoc)holder, name);
        } else if (holder instanceof MemberDoc) {
            doc = this.findClass(((MemberDoc)holder).containingClass(), name);
        }
        return doc;
    }

    private ClassDoc findClass(ClassDoc holder, String name) {
        return holder.findClass(name);
    }

    private ClassDoc findClass(PackageDoc holder, String name) {
        ClassDoc doc = Stream.of(holder.allClasses(true)).map(t -> t.findClass(name)).filter(Objects::nonNull).findFirst().orElse(holder.findClass(name));
        return doc;
    }

    protected RootDoc getRootDoc() {
        return this.configuration != null ? this.configuration.root : null;
    }

    protected ClassDoc getClassDocFor(Tag tag, Class<?> type) {
        return this.getClassDocFor(tag, type.getCanonicalName());
    }

    protected FieldDoc getFieldDocFor(Tag tag, Field field) {
        FieldDoc fieldDoc = null;
        ClassDoc classDoc = this.getClassDocFor(tag, field.getDeclaringClass());
        if (classDoc != null) {
            fieldDoc = Stream.of(classDoc.fields(true)).filter(t -> t.name().equals(field.getName())).findFirst().orElse(null);
        }
        return fieldDoc;
    }

    protected ConstructorDoc getConstructorDocFor(Tag tag, Constructor<?> constructor) {
        ConstructorDoc constructorDoc = null;
        ClassDoc classDoc = this.getClassDocFor(tag, constructor.getDeclaringClass());
        if (classDoc != null) {
            constructorDoc = Stream.of(classDoc.constructors(true)).filter(t -> t.signature().equals(this.signature(constructor))).findFirst().orElse(null);
        }
        return constructorDoc;
    }

    protected MethodDoc getMethodDocFor(Tag tag, Method method) {
        MethodDoc methodDoc = null;
        ClassDoc classDoc = this.getClassDocFor(tag, method.getDeclaringClass());
        if (classDoc != null) {
            methodDoc = Stream.of(classDoc.methods(true)).filter(t -> t.name().equals(method.getName())).filter(t -> t.signature().equals(this.signature(method))).findFirst().orElse(null);
        }
        return methodDoc;
    }

    protected Class<?> getClassFor(String name) {
        Class<?> type = null;
        try {
            type = this.getClassLoader().loadClass(name);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return type;
    }

    protected Class<?> getClassFor(PackageDoc doc) {
        Class<?> type = null;
        try {
            if (doc != null) {
                String name = doc.name() + ".package-info";
                type = this.getClassFor(name);
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return type;
    }

    protected Class<?> getClassFor(ClassDoc doc) {
        Class<?> type = null;
        try {
            if (doc != null) {
                String name = this.getClassNameFor(doc);
                type = this.getClassFor(name);
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return type;
    }

    private String getClassNameFor(ClassDoc doc) {
        String name = null;
        if (doc != null) {
            name = doc.containingClass() != null ? this.getClassNameFor(doc.containingClass()) + "$" + doc.simpleTypeName() : doc.qualifiedName();
        }
        return name;
    }

    protected String getResourcePathOf(Class<?> type) {
        String path = String.join((CharSequence)"/", type.getName().split(Pattern.quote("."))) + ".class";
        return path;
    }

    protected URL getResourceURLOf(Class<?> type) {
        return type.getResource("/" + this.getResourcePathOf(type));
    }

    protected BeanInfo getBeanInfo(Class<?> start, Class<?> stop) {
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(start, stop);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return info;
    }

    protected BeanInfo getBeanInfo(Class<?> start) {
        return this.getBeanInfo(start, Object.class);
    }

    @Override
    protected ClassLoader getClassLoader() {
        if (this.loader == null) {
            this.loader = this.getClassPathClassLoader(this.fm, this.getClass().getClassLoader());
        }
        return this.loader;
    }

    @Override
    public URI href(Tag tag, Object target) {
        URI uri = null;
        if (this.href == null) {
            this.href = new Object(){}.getClass().getEnclosingMethod();
        }
        if (target != null) {
            Class[] parameters = (Class[])Stream.of(Tag.class, target.getClass()).toArray(Class[]::new);
            try {
                Method method = AbstractTaglet.class.getDeclaredMethod(this.href.getName(), parameters);
                if (Objects.equals(this.href, method) || !this.href.getReturnType().isAssignableFrom(method.getReturnType())) {
                    throw new NoSuchMethodException();
                }
                Object[] arguments = Stream.of(tag, target).toArray(Object[]::new);
                uri = (URI)method.invoke((Object)this, arguments);
            }
            catch (Exception exception) {
                System.err.println(tag.position() + ": No method to get href for " + parameters[parameters.length - 1].getName());
            }
        }
        return uri;
    }

    private URI href(Tag tag, CharSequence target) {
        URI href = null;
        if (target != null) {
            String name = target.toString();
            href = this.href(tag, (ProgramElementDoc)this.getClassDocFor(tag, name));
        }
        return href;
    }

    private URI href(Tag tag, ProgramElementDoc target) {
        URI href = null;
        if (target != null) {
            DocLink link;
            ClassDoc classDoc = this.containingClass((Doc)target);
            PackageDoc packageDoc = this.containingPackage((Doc)target);
            if (target.isIncluded()) {
                int depth = this.getComponentsOf(this.containingPackage(tag)).length;
                String path = Stream.concat(Stream.generate(() -> "..").limit(depth), Stream.of(this.getComponentsOf(packageDoc))).collect(Collectors.joining("/", "./", "/")) + classDoc.name() + ".html";
                href = URI.create(path).normalize();
            } else if (this.configuration != null && (link = this.configuration.extern.getExternalLink(packageDoc.name(), null, classDoc.name() + ".html")) != null) {
                href = URI.create(link.toString());
            }
        }
        if (href != null && target instanceof MemberDoc) {
            String fragment = "#" + target.name();
            if (target instanceof ExecutableMemberDoc) {
                fragment = fragment + ((ExecutableMemberDoc)target).signature().replaceAll("[(),]", "-");
            }
            href = href.resolve(fragment);
        }
        return href;
    }

    private URI href(Tag tag, Class<?> target) {
        return this.href(tag, (ProgramElementDoc)(target != null ? this.getClassDocFor(tag, target) : null));
    }

    private URI href(Tag tag, Member member) {
        URI href = null;
        FieldDoc target = null;
        if (member instanceof Field) {
            target = this.getFieldDocFor(tag, (Field)member);
        } else if (member instanceof Constructor) {
            target = this.getConstructorDocFor(tag, (Constructor)member);
        } else if (member instanceof Method) {
            target = this.getMethodDocFor(tag, (Method)member);
        }
        if (target != null) {
            href = this.href(tag, (ProgramElementDoc)target);
        }
        return href;
    }

    private String[] getComponentsOf(PackageDoc doc) {
        String name = doc != null ? doc.name() : null;
        return StringUtils.isNotEmpty(name) ? name.split(Pattern.quote(".")) : new String[]{};
    }

    @Override
    public FluentNode a(Tag tag, ProgramElementDoc target, Node node) {
        if (node == null) {
            node = this.code(target.name());
        }
        return this.a(target != null ? this.href(tag, target) : null, node);
    }

    @Override
    public FluentNode a(Tag tag, Class<?> type, Node node) {
        String brackets = "";
        while (type.isArray()) {
            brackets = "[]" + brackets;
            type = type.getComponentType();
        }
        ClassDoc target = this.getClassDocFor(tag, type);
        if (node == null) {
            String name = target != null ? target.name() : type.getCanonicalName();
            node = this.code(name + brackets);
        }
        return this.a(tag, (ProgramElementDoc)target, node);
    }

    @Override
    public FluentNode a(Tag tag, Member member, Node node) {
        if (node == null) {
            node = this.code(member.getName());
        }
        return this.a(this.href(tag, member), node);
    }

    @Override
    public FluentNode a(Tag tag, String name, Node node) {
        ClassDoc target = this.getClassDocFor(tag, name);
        if (node == null) {
            node = this.code(target != null ? target.name() : name);
        }
        return this.a(tag, (ProgramElementDoc)target, node);
    }
}

