/*
 * Decompiled with CFR 0.152.
 */
package ball.tools.javadoc;

import ball.xml.FluentNode;
import ball.xml.HTMLTemplates;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;

public interface JavadocHTMLTemplates
extends HTMLTemplates {
    public URI href(Tag var1, Object var2);

    public FluentNode a(Tag var1, ProgramElementDoc var2, Node var3);

    public FluentNode a(Tag var1, Class<?> var2, Node var3);

    public FluentNode a(Tag var1, Member var2, Node var3);

    public FluentNode a(Tag var1, String var2, Node var3);

    default public FluentNode a(Tag tag, Class<?> type) {
        return this.a(tag, type, (String)null);
    }

    default public FluentNode a(Tag tag, Class<?> type, String name) {
        return this.a(tag, type, name != null ? this.code(name) : null);
    }

    default public FluentNode a(Tag tag, Member member) {
        return this.a(tag, member, (String)null);
    }

    default public FluentNode a(Tag tag, Member member, String name) {
        return this.a(tag, member, name != null ? this.code(name) : null);
    }

    default public FluentNode a(Tag tag, Enum<?> constant) {
        return this.a(tag, constant.getDeclaringClass(), constant.name());
    }

    default public FluentNode declaration(Tag tag, Member member) {
        FluentNode node = null;
        if (member instanceof Field) {
            node = this.declaration(tag, (Field)member);
        } else if (member instanceof Method) {
            node = this.declaration(tag, (Method)member);
        } else {
            throw new IllegalArgumentException(String.valueOf(member));
        }
        return node;
    }

    default public FluentNode declaration(Tag tag, Field field) {
        return this.fragment(this.modifiers(field.getModifiers()), this.type(tag, field.getGenericType()), this.code(" "), this.a(tag, (Member)field, (String)null));
    }

    default public FluentNode declaration(Tag tag, Method method) {
        FluentNode node = this.fragment(this.modifiers(method.getModifiers()), this.type(tag, method.getGenericReturnType()), this.code(" "), this.a(tag, (Member)method, (String)null));
        Parameter[] parameters = method.getParameters();
        node.add(this.code("("));
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                node.add(this.code(", "));
            }
            node.add(this.declaration(tag, parameters[i]));
        }
        node.add(this.code(")"));
        return node;
    }

    default public FluentNode declaration(Tag tag, Parameter parameter) {
        return this.fragment(this.modifiers(parameter.getModifiers()), this.type(tag, parameter.getParameterizedType()), this.code(" "), this.code(parameter.getName()));
    }

    default public FluentNode annotation(Tag tag, Annotation annotation) {
        Class<? extends Annotation> type = annotation.annotationType();
        String string = String.valueOf(annotation).replace(type.getCanonicalName(), type.getSimpleName()).replaceAll("[(][)]$", "");
        return this.fragment(new Node[0]).add(this.a(this.href(tag, type), this.code(string)));
    }

    default public FluentNode modifiers(int modifiers) {
        FluentNode node = this.fragment(new Node[0]);
        String string = Modifier.toString(modifiers);
        if (StringUtils.isNotEmpty(string)) {
            node.add(this.code(string + " "));
        }
        return node;
    }

    default public FluentNode type(Tag tag, Type type) {
        FluentNode node = null;
        if (type instanceof ParameterizedType) {
            node = this.fragment(this.type(tag, ((ParameterizedType)type).getRawType()));
            Type[] types = ((ParameterizedType)type).getActualTypeArguments();
            node = node.add(this.code("<"));
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    node.add(this.code(","));
                }
                node.add(this.type(tag, types[i]));
            }
            node.add(this.code(">"));
        } else {
            node = type instanceof Class ? this.a(tag, (Class)type) : this.code(type.getTypeName());
        }
        return node;
    }

    default public FluentNode table(Tag tag, TableModel model, Stream<Node> stream) {
        return this.table(tag, model, (Node[])stream.toArray(Node[]::new));
    }

    default public FluentNode table(Tag tag, TableModel model, Node ... nodes) {
        FluentNode table = this.table(new Node[0]);
        CharSequence[] names = (String[])IntStream.range(0, model.getColumnCount()).boxed().map(model::getColumnName).toArray(String[]::new);
        if (!StringUtils.isAllBlank(names)) {
            table.add(this.thead(this.tr(Stream.of(names).map(this::th))));
        }
        table.add(this.tbody(IntStream.range(0, model.getRowCount()).boxed().map(arg_0 -> this.lambda$table$3((String[])names, tag, model, arg_0))));
        return table.add(nodes);
    }

    default public FluentNode toHTML(Tag tag, Object object) {
        FluentNode node = null;
        if (object instanceof byte[]) {
            node = this.text(Stream.of(ArrayUtils.toObject((byte[])object)).map(t -> String.format("0x%02X", t)).collect(Collectors.joining(", ", "[", "]")));
        } else if (object instanceof boolean[]) {
            node = this.text(Arrays.toString((boolean[])object));
        } else if (object instanceof double[]) {
            node = this.text(Arrays.toString((double[])object));
        } else if (object instanceof float[]) {
            node = this.text(Arrays.toString((float[])object));
        } else if (object instanceof int[]) {
            node = this.text(Arrays.toString((int[])object));
        } else if (object instanceof long[]) {
            node = this.text(Arrays.toString((long[])object));
        } else if (object instanceof Object[]) {
            node = this.toHTML(tag, Arrays.asList((Object[])object));
        } else if (object instanceof Type) {
            node = this.type(tag, (Type)object);
        } else if (object instanceof Enum) {
            node = this.a(tag, (Enum)object);
        } else if (object instanceof Field) {
            node = this.a(tag, (Field)object);
        } else if (object instanceof Constructor) {
            node = this.a(tag, (Constructor)object);
        } else if (object instanceof Method) {
            node = this.a(tag, (Method)object);
        } else if (object instanceof Collection) {
            List nodes = ((Collection)object).stream().map(t -> this.toHTML(tag, t)).collect(Collectors.toList());
            for (int i = nodes.size() - 1; i > 0; --i) {
                nodes.add(i, this.text(", "));
            }
            node = this.fragment(new Node[0]).add(this.text("[")).add(nodes.stream()).add(this.text("]"));
        } else {
            node = this.text(String.valueOf(object));
        }
        return node;
    }

    private /* synthetic */ Node lambda$table$3(String[] names, Tag tag, TableModel model, Integer y) {
        return this.tr(IntStream.range(0, names.length).boxed().map(x -> this.td(this.toHTML(tag, model.getValueAt(y, (int)x)))));
    }
}

