/*
 * Decompiled with CFR 0.152.
 */
package ball.tools.javadoc;

import ball.annotation.ServiceProviderFor;
import ball.annotation.processing.AnnotatedProcessor;
import ball.annotation.processing.For;
import ball.annotation.processing.TargetMustExtend;
import ball.tools.javadoc.AnnotatedTaglet;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import lombok.Generated;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@TargetMustExtend(value=AnnotatedTaglet.class)
public @interface TagletName {
    public String value();

    @ServiceProviderFor(value={Processor.class})
    @For(value={TagletName.class})
    public static class ProcessorImpl
    extends AnnotatedProcessor {
        @Override
        protected void process(RoundEnvironment roundEnv, TypeElement annotation, Element element) {
            super.process(roundEnv, annotation, element);
            AnnotationMirror mirror = this.getAnnotationMirror(element, annotation);
            AnnotationValue value = this.getAnnotationValue(mirror, "value");
            String name = (String)value.getValue();
            if (!name.isEmpty()) {
                if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    this.print(Diagnostic.Kind.ERROR, element, mirror, "%s is %s", new Object[]{element.getKind(), Modifier.ABSTRACT});
                }
            } else {
                this.print(Diagnostic.Kind.ERROR, element, mirror, value, "value() must be a non-empty String", new Object[0]);
            }
        }

        @Generated
        public ProcessorImpl() {
        }

        @Override
        @Generated
        public String toString() {
            return "TagletName.ProcessorImpl()";
        }
    }
}

