/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;

public class Coordinate
implements Comparable<Coordinate>,
Serializable {
    private static final long serialVersionUID = -4428900365914120909L;
    private static final Comparator<? super Coordinate> COMPARATOR = Comparator.comparingInt(Coordinate::getY).thenComparingInt(Coordinate::getX);
    private final int y;
    private final int x;

    @ConstructorProperties(value={"y", "x"})
    public Coordinate(Number y, Number x) {
        this(y.intValue(), x.intValue());
    }

    private Coordinate(int y, int x) {
        this.y = y;
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public Coordinate translate(Number dy, Number dx) {
        return new Coordinate(this.getY() + dy.intValue(), this.getX() + dx.intValue());
    }

    public Coordinate translate(Coordinate ds) {
        return this.translate(ds.getY(), ds.getX());
    }

    public boolean within(Coordinate min, Coordinate max) {
        return min.getY() <= this.getY() && this.getY() < max.getY() && min.getX() <= this.getX() && this.getX() < max.getX();
    }

    public Point2D asPoint() {
        return new Point(this.getX(), this.getY());
    }

    @Override
    public int compareTo(Coordinate that) {
        return Objects.compare(this, that, COMPARATOR);
    }

    public boolean equals(Object object) {
        return object instanceof Coordinate ? this.compareTo((Coordinate)object) == 0 : super.equals(object);
    }

    public int hashCode() {
        return Arrays.asList(this.y, this.x).hashCode();
    }

    public String toString() {
        return Arrays.asList(this.y, this.x).toString();
    }

    public static SortedSet<Coordinate> range(Coordinate min, Coordinate max) {
        return Coordinate.range(Math.min(min.getY(), max.getY()), Math.min(min.getX(), max.getX()), Math.max(min.getY(), max.getY()), Math.max(min.getX(), max.getX()));
    }

    public static SortedSet<Coordinate> range(int y0, int x0, int yN, int xN) {
        TreeSet<Coordinate> set = new TreeSet<Coordinate>();
        for (int y = y0; y < yN; ++y) {
            for (int x = x0; x < xN; ++x) {
                set.add(new Coordinate(y, x));
            }
        }
        return set;
    }
}

