/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import ball.util.Coordinate;
import ball.util.MapView;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class CoordinateMap<V>
extends MapView<Coordinate, V>
implements SortedMap<Coordinate, V>,
TableModel {
    private static final long serialVersionUID = -7283339807212986103L;
    private Coordinate min = null;
    private Coordinate max = null;
    private final EventListenerList list = new EventListenerList();

    public CoordinateMap() {
        super(new TreeMap());
    }

    public CoordinateMap(Number y0, Number x0, Number yN, Number xN) {
        this();
        this.resize(y0, x0, yN, xN);
    }

    public CoordinateMap(Number yN, Number xN) {
        this(0, 0, yN, xN);
    }

    private CoordinateMap(Map<Coordinate, V> map, Number y0, Number x0, Number yN, Number xN) {
        super(map);
        this.resize(y0, x0, yN, xN);
    }

    @Override
    protected SortedMap<Coordinate, V> map() {
        return (SortedMap)super.map();
    }

    protected Type getType() {
        return ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public CoordinateMap<V> resize(Number y0, Number x0, Number yN, Number xN) {
        this.resize(y0.intValue(), x0.intValue(), yN.intValue(), xN.intValue());
        return this;
    }

    public CoordinateMap<V> resize(Number yN, Number xN) {
        return this.resize((Number)0, (Number)0, yN, xN);
    }

    private void resize(int y0, int x0, int yN, int xN) {
        this.min = new Coordinate((Number)Math.min(y0, yN), (Number)Math.min(x0, xN));
        this.max = new Coordinate((Number)Math.max(y0, yN), (Number)Math.max(x0, xN));
        this.keySet().retainAll(Coordinate.range(this.min, this.max));
        this.fireTableStructureChanged();
    }

    public Coordinate getMin() {
        return this.min;
    }

    public Coordinate getMax() {
        return this.max;
    }

    public int getMinY() {
        return this.getMin().getY();
    }

    public int getMinX() {
        return this.getMin().getX();
    }

    public int getMaxY() {
        return this.getMax().getY();
    }

    public int getMaxX() {
        return this.getMax().getX();
    }

    public boolean includes(Coordinate coordinate) {
        return coordinate.within(this.getMin(), this.getMax());
    }

    public List<CoordinateMap<V>> columns() {
        ArrayList<CoordinateMap<V>> list = new ArrayList<CoordinateMap<V>>(this.getColumnCount());
        if (this.getColumnCount() > 0) {
            int xN = this.getMaxX();
            for (int x = this.getMinX(); x < xN; ++x) {
                list.add(this.column(x));
            }
        }
        return list;
    }

    public List<CoordinateMap<V>> rows() {
        ArrayList<CoordinateMap<V>> list = new ArrayList<CoordinateMap<V>>(this.getRowCount());
        if (this.getRowCount() > 0) {
            int yN = this.getMaxY();
            for (int y = this.getMinY(); y < yN; ++y) {
                list.add(this.row(y));
            }
        }
        return list;
    }

    public CoordinateMap<V> column(Number x) {
        return this.subMap(this.getMinY(), x, this.getMaxY(), x.intValue() + 1);
    }

    public CoordinateMap<V> row(Number y) {
        return this.subMap(y, this.getMinX(), y.intValue() + 1, this.getMaxX());
    }

    public CoordinateMap<V> subMap(Number y0, Number x0, Number yN, Number xN) {
        return new Sub(this, y0, x0, yN, xN);
    }

    public List<V> asList() {
        return new BackedList();
    }

    public boolean containsKey(Number y, Number x) {
        return this.containsKey(new Coordinate(y, x));
    }

    public V get(Number y, Number x) {
        return this.get(new Coordinate(y, x));
    }

    public V put(Number y, Number x, V value) {
        return this.put(new Coordinate(y, x), value);
    }

    @Override
    public V put(Coordinate key, V value) {
        this.min = this.min != null ? new Coordinate((Number)Math.min(key.getY(), this.getMinY()), (Number)Math.min(key.getX(), this.getMinX())) : key;
        this.max = this.max != null ? new Coordinate((Number)Math.max(key.getY() + 1, this.getMaxY()), (Number)Math.max(key.getX() + 1, this.getMaxX())) : new Coordinate((Number)(key.getY() + 1), (Number)(key.getX() + 1));
        V old = super.put(key, value);
        this.fireTableCellUpdated(key.getY() - this.getMinY(), key.getX() - this.getMinX());
        return old;
    }

    @Override
    public V remove(Object key) {
        Object old = super.remove(key);
        if (key instanceof Coordinate) {
            Coordinate coordinate = (Coordinate)key;
            this.fireTableCellUpdated(coordinate.getY() - this.getMinY(), coordinate.getX() - this.getMinX());
        }
        return old;
    }

    @Override
    public Comparator<? super Coordinate> comparator() {
        return this.map().comparator();
    }

    public CoordinateMap<V> subMap(Coordinate from, Coordinate to) {
        throw new UnsupportedOperationException();
    }

    public CoordinateMap<V> headMap(Coordinate key) {
        throw new UnsupportedOperationException();
    }

    public CoordinateMap<V> tailMap(Coordinate key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Coordinate firstKey() {
        return (Coordinate)this.map().firstKey();
    }

    @Override
    public Coordinate lastKey() {
        return (Coordinate)this.map().lastKey();
    }

    @Override
    public void clear() {
        super.clear();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.getMax() != null ? this.getMaxY() - this.getMinY() : 0;
    }

    @Override
    public int getColumnCount() {
        return this.getMax() != null ? this.getMaxX() - this.getMinX() : 0;
    }

    @Override
    public String getColumnName(int x) {
        return null;
    }

    public Class<? extends V> getColumnClass(int x) {
        return (Class)this.getType();
    }

    @Override
    public boolean isCellEditable(int y, int x) {
        return false;
    }

    public V getValueAt(int y, int x) {
        return this.get(y - this.getMinY(), x - this.getMinX());
    }

    @Override
    public void setValueAt(Object value, int y, int x) {
        this.put(y - this.getMinY(), x - this.getMinX(), this.getColumnClass(x).cast(value));
    }

    @Override
    public void addTableModelListener(TableModelListener listener) {
        this.list.add(TableModelListener.class, listener);
    }

    @Override
    public void removeTableModelListener(TableModelListener listener) {
        this.list.remove(TableModelListener.class, listener);
    }

    protected TableModelListener[] getTableModelListeners() {
        return (TableModelListener[])this.list.getListeners(TableModelListener.class);
    }

    protected void fireTableDataChanged() {
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected void fireTableStructureChanged() {
        this.fireTableChanged(new TableModelEvent(this, -1));
    }

    protected void fireTableRowsInserted(int start, int end) {
        this.fireTableChanged(new TableModelEvent(this, start, end, -1, 1));
    }

    protected void fireTableRowsUpdated(int start, int end) {
        this.fireTableChanged(new TableModelEvent(this, start, end, -1, 0));
    }

    protected void fireTableRowsDeleted(int start, int end) {
        this.fireTableChanged(new TableModelEvent(this, start, end, -1, -1));
    }

    protected void fireTableCellUpdated(int row, int column) {
        this.fireTableChanged(new TableModelEvent(this, row, row, column));
    }

    protected void fireTableChanged(TableModelEvent event) {
        TableModelListener[] listeners = this.getTableModelListeners();
        for (int i = listeners.length - 1; i >= 0; --i) {
            listeners[i].tableChanged(event);
        }
    }

    private class BackedList
    extends AbstractList<V> {
        private ArrayList<Coordinate> list = new ArrayList();

        public BackedList() {
            this.list.addAll(Coordinate.range(CoordinateMap.this.getMin(), CoordinateMap.this.getMax()));
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public V get(int index) {
            return CoordinateMap.this.get(this.list.get(index));
        }

        @Override
        public V set(int index, V value) {
            return CoordinateMap.this.put(this.list.get(index), value);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private static class Sub<V>
    extends CoordinateMap<V> {
        private static final long serialVersionUID = -7614329296625073237L;

        public Sub(CoordinateMap<V> map, Number y0, Number x0, Number yN, Number xN) {
            super(map, y0, x0, yN, xN);
        }

        @Override
        protected CoordinateMap<V> map() {
            return (CoordinateMap)super.map();
        }

        @Override
        public V get(Object key) {
            return this.get((Coordinate)key);
        }

        private V get(Coordinate key) {
            return key.within(this.getMin(), this.getMax()) ? (V)super.get(key) : null;
        }

        @Override
        public V put(Coordinate key, V value) {
            if (!key.within(this.getMin(), this.getMax())) {
                throw new IllegalArgumentException(key + " is outside " + this.getMin() + " and " + this.getMax());
            }
            return super.put(key, value);
        }

        @Override
        public V remove(Object key) {
            return this.remove((Coordinate)key);
        }

        private V remove(Coordinate key) {
            return key.within(this.getMin(), this.getMax()) ? (V)super.remove(key) : null;
        }

        @Override
        public Set<Map.Entry<Coordinate, V>> entrySet() {
            this.entrySet.clear();
            for (Map.Entry entry : ((MapView)((Object)this.map())).entrySet()) {
                if (!((Coordinate)entry.getKey()).within(this.getMin(), this.getMax())) continue;
                this.entrySet.add(entry);
            }
            return this.entrySet;
        }
    }
}

