/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class Factory<T>
extends TreeMap<Class<?>[], Member> {
    private static final long serialVersionUID = -5733222257965875050L;
    private final Class<? extends T> type;
    private final Object factory;

    @ConstructorProperties(value={"type"})
    public Factory(Class<? extends T> type) {
        this(type, null);
    }

    @ConstructorProperties(value={"type", "factory"})
    protected Factory(Class<? extends T> type, Object factory) {
        super(Comparator.comparing(Arrays::toString));
        this.type = type;
        this.factory = factory;
        CandidateSet set = new CandidateSet(type);
        if (factory != null) {
            Arrays.stream(factory.getClass().getMethods()).filter(t -> Modifier.isPublic(t.getModifiers())).filter(t -> type.isAssignableFrom(t.getReturnType())).filter(t -> set.contains(t.getName())).forEach((? super T t) -> {
                Member cfr_ignored_0 = this.putIfAbsent(t.getParameterTypes(), t);
            });
        }
        Arrays.stream(type.getMethods()).filter(t -> Modifier.isPublic(t.getModifiers()) && Modifier.isStatic(t.getModifiers())).filter(t -> type.isAssignableFrom(t.getReturnType())).filter(t -> set.contains(t.getName())).forEach((? super T t) -> {
            Member cfr_ignored_0 = this.putIfAbsent(t.getParameterTypes(), t);
        });
        Arrays.stream(type.getConstructors()).filter(t -> Modifier.isPublic(t.getModifiers())).forEach((? super T t) -> {
            Member cfr_ignored_0 = this.putIfAbsent(t.getParameterTypes(), t);
        });
    }

    public Class<? extends T> getType() {
        return this.type;
    }

    public Object getFactory() {
        return this.factory;
    }

    public T getInstance(Class<?>[] parameters, Object ... arguments) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return this.apply(this.getFactoryMethod(parameters), arguments);
    }

    public T getInstance(Object ... arguments) throws IllegalAccessException, IllegalArgumentException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        return this.getInstance(Factory.typesOf(arguments), arguments);
    }

    public boolean hasFactoryMethodFor(Class<?> ... parameters) {
        boolean hasMember = false;
        try {
            this.getFactoryMethod(parameters);
            hasMember = this.get(parameters) != null;
        }
        catch (NoSuchMethodException exception) {
            hasMember = false;
        }
        return hasMember;
    }

    public Member getFactoryMethod(Class<?> ... parameters) throws NoSuchMethodException {
        if (!this.containsKey(parameters)) {
            this.put(parameters, this.getType().getConstructor(parameters));
        }
        return this.get(parameters);
    }

    public T apply(Member member, Object ... arguments) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object object = null;
        if (member instanceof Method) {
            object = ((Method)member).invoke(this.factory, arguments);
        } else if (member instanceof Constructor) {
            object = ((Constructor)member).newInstance(arguments);
        } else if (member instanceof Field) {
            object = ((Field)member).get(null);
        } else {
            throw new IllegalArgumentException("member=" + member);
        }
        return this.getType().cast(object);
    }

    @Override
    public Member get(Object key) {
        Member value = null;
        if (key instanceof Class[]) {
            if (!super.containsKey(key)) {
                for (Map.Entry entry : this.entrySet()) {
                    if (!Factory.isApplicable((Class[])entry.getKey(), (Class[])key)) continue;
                    value = (Member)entry.getValue();
                    break;
                }
                super.put((Class[])key, value);
            }
            value = (Member)super.get(key);
        }
        return value;
    }

    protected static Class<?>[] typesOf(Object ... arguments) {
        Class[] types = new Class[arguments.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = arguments[i].getClass();
        }
        return types;
    }

    protected static boolean isApplicable(Class<?>[] parameters, Class<?> ... arguments) {
        boolean match = parameters.length == arguments.length;
        for (int i = 0; match && i < arguments.length; match &= parameters[i].isAssignableFrom(arguments[i]), ++i) {
        }
        return match;
    }

    private class CandidateSet
    extends TreeSet<String> {
        private static final long serialVersionUID = -7927801377734740425L;

        public CandidateSet(Class<? extends T> type) {
            super(Arrays.asList("compile", "create", "decode", "forName", "getDefault", "getDefaultInstance", "getInstance", "getObjectInstance", "new" + type.getSimpleName(), "newInstance", "valueOf"));
            if (!(type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Long.class))) {
                this.add("get" + type.getSimpleName());
            }
        }
    }
}

