/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class ListOrderComparator<T>
implements Comparator<T> {
    private final List<T> list;

    public ListOrderComparator(List<T> list) {
        this.list = Objects.requireNonNull(list);
    }

    @SafeVarargs
    public ListOrderComparator(T ... array) {
        this(Arrays.asList(array));
    }

    @Override
    public int compare(T left, T right) {
        return this.rank(left) - this.rank(right);
    }

    private int rank(T object) {
        int index = this.list.indexOf(object);
        return index >= 0 ? index : this.list.size();
    }
}

