/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MapView<K, V>
extends AbstractMap<K, V>
implements Serializable {
    private static final long serialVersionUID = -1914866590078121842L;
    private final Map<K, V> map;
    protected final EntrySet entrySet = new EntrySet();

    public MapView(Map<K, V> map) {
        this.map = map;
    }

    protected Map<K, V> map() {
        return this.map;
    }

    @Override
    public V get(Object key) {
        return this.map().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.map().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.map().remove(key);
    }

    @Override
    public void clear() {
        this.map().clear();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.entrySet.clear();
        this.entrySet.addAll(this.map().entrySet());
        return this.entrySet;
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> iterator;
        private Map.Entry<K, V> current = null;

        public EntryIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public void remove() {
            this.iterator.remove();
            MapView.this.remove(this.current.getKey());
        }

        public String toString() {
            return this.iterator.toString();
        }
    }

    protected class EntrySet
    extends LinkedHashSet<Map.Entry<K, V>> {
        private static final long serialVersionUID = 5015923978722180032L;

        @Override
        public boolean remove(Object object) {
            boolean changed = super.remove(object);
            if (changed) {
                MapView.this.remove(((Map.Entry)object).getKey());
            }
            return changed;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            ArrayList list = new ArrayList();
            Iterator iterator = super.iterator();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return new EntryIterator(list.iterator());
        }
    }
}

