/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import ball.annotation.MatcherGroup;
import ball.annotation.PatternRegex;
import ball.util.Converter;
import java.lang.annotation.AnnotationFormatError;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;

public interface PatternMatcherBean {
    default public void initialize(CharSequence sequence) {
        Matcher matcher = this.matcher(sequence);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("\"" + String.valueOf(sequence) + "\" does not match " + matcher.pattern().pattern());
        }
        try {
            Object value;
            List<Field> fields = FieldUtils.getFieldsListWithAnnotation(this.getClass(), MatcherGroup.class);
            for (Field field : fields) {
                MatcherGroup group = field.getAnnotation(MatcherGroup.class);
                String string = matcher.group(group.value());
                value = string != null ? Converter.convertTo(string, field.getType()) : null;
                FieldUtils.writeField(field, this, value, true);
            }
            List<Method> methods = MethodUtils.getMethodsListWithAnnotation(this.getClass(), MatcherGroup.class, true, true);
            for (Method method : methods) {
                MatcherGroup group = method.getAnnotation(MatcherGroup.class);
                value = Converter.convertTo(matcher.group(group.value()), method.getParameterTypes()[0]);
                MethodUtils.invokeMethod((Object)this, true, method.getName(), new Object[]{value}, method.getParameterTypes());
            }
        }
        catch (IllegalAccessException exception) {
            exception.printStackTrace(System.err);
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.valueOf(matcher), exception);
        }
    }

    default public Matcher matcher(CharSequence sequence) {
        return this.pattern().matcher(sequence);
    }

    default public Pattern pattern() {
        Pattern pattern = null;
        PatternRegex annotation = this.getClass().getAnnotation(PatternRegex.class);
        try {
            pattern = Pattern.compile(annotation.value());
        }
        catch (Exception exception) {
            throw new AnnotationFormatError(annotation.toString(), exception);
        }
        return pattern;
    }
}

