/*
 * Decompiled with CFR 0.152.
 */
package ball.util;

import ball.util.Converter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Properties;

public class PropertiesImpl
extends Properties {
    private static final long serialVersionUID = -5034894719756448226L;
    protected static final Charset CHARSET = StandardCharsets.UTF_8;

    public PropertiesImpl() {
        this((Properties)null);
    }

    public PropertiesImpl(Properties defaults) {
        super(defaults);
    }

    public PropertiesImpl(Properties defaults, File file) throws IOException {
        this(defaults);
        if (file != null) {
            try (FileInputStream in = new FileInputStream(file);){
                this.load(in);
            }
        }
    }

    public PropertiesImpl(Properties defaults, String resource) throws IOException {
        this(defaults);
        if (resource != null) {
            try (InputStream in = this.getClass().getResourceAsStream(resource);){
                this.load(in);
            }
        }
    }

    public Object configure(Object object) throws Exception {
        return PropertiesImpl.configure(this, object);
    }

    @Override
    public void load(InputStream in) throws IOException {
        PropertiesImpl.load(this, in);
    }

    @Override
    public void store(OutputStream out, String comment) throws IOException {
        PropertiesImpl.store(this, out, comment);
    }

    protected static void load(Properties properties, InputStream in) throws IOException {
        properties.load(new InputStreamReader(in, CHARSET));
    }

    protected static void store(Properties properties, OutputStream out, String comment) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, CHARSET);
        properties.store(writer, comment);
        writer.flush();
    }

    public static Object configure(Properties properties, Object object) throws Exception {
        Iterator<String> iterator = properties.stringPropertyNames().iterator();
        while (iterator.hasNext()) {
            String key;
            Object value = properties.get(key = iterator.next());
            Method method = PropertiesImpl.getSetMethod(object, key, value != null ? value.getClass() : null);
            if (method == null) continue;
            value = Converter.convertTo(value, method.getParameterTypes()[0]);
            method.invoke(object, value);
        }
        return object;
    }

    private static Method getSetMethod(Object object, String property, Class<?> parameter) {
        Method method = null;
        String name = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        if (method == null && parameter != null) {
            try {
                method = object.getClass().getMethod(name, parameter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (method == null) {
            for (Method m : object.getClass().getMethods()) {
                if (!m.getName().equals(name) || m.isVarArgs() || m.getParameterTypes().length != 1) continue;
                method = m;
                break;
            }
        }
        return method;
    }
}

