/*
 * Decompiled with CFR 0.152.
 */
package ball.util.ant.taskdefs;

import ball.beans.PropertyMethodEnum;
import ball.util.ant.taskdefs.AntTaskAttributeConstraint;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskConfigurationChecker;

public class AnnotatedAntTaskConfigurationChecker
extends TaskConfigurationChecker {
    private final Task task;

    public AnnotatedAntTaskConfigurationChecker(Task task) {
        super(task);
        this.task = task;
        HashSet set = new HashSet();
        set.add(task.getClass());
        set.addAll(ClassUtils.getAllSuperclasses(task.getClass()));
        set.addAll(ClassUtils.getAllInterfaces(task.getClass()));
        for (Class clazz : set) {
            ArrayList list = new ArrayList();
            Collections.addAll(list, clazz.getDeclaredFields());
            Collections.addAll(list, clazz.getDeclaredMethods());
            for (AnnotatedElement element : list) {
                for (Annotation annotation : element.getAnnotations()) {
                    AntTaskAttributeConstraint constraint = annotation.annotationType().getAnnotation(AntTaskAttributeConstraint.class);
                    if (constraint == null) continue;
                    this.assertConfig(constraint, element);
                }
            }
        }
    }

    private void assertConfig(AntTaskAttributeConstraint constraint, AnnotatedElement element) {
        try {
            String name = null;
            Object value = null;
            if (element instanceof Field) {
                name = ((Field)element).getName();
                value = FieldUtils.readField((Field)element, this.task, true);
            } else if (element instanceof Method) {
                name = PropertyMethodEnum.getPropertyName((Method)element);
                value = MethodUtils.invokeMethod((Object)this.task, true, ((Method)element).getName(), new Object[0]);
            } else {
                throw new IllegalStateException(String.valueOf(element));
            }
            constraint.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).check(this.task, this, name, value);
        }
        catch (Exception exception) {
            this.fail(exception.toString());
        }
    }

    @Generated
    public String toString() {
        return "AnnotatedAntTaskConfigurationChecker(task=" + this.task + ")";
    }
}

