/*
 * Decompiled with CFR 0.152.
 */
package ball.util.ant.taskdefs;

import ball.text.TextTable;
import ball.util.ant.taskdefs.AntTaskMixIn;
import java.io.BufferedReader;
import java.io.File;
import java.util.stream.Stream;
import javax.swing.table.TableModel;

public interface AntTaskLogMethods
extends AntTaskMixIn {
    public void log(String var1);

    public void log(String var1, int var2);

    public void log(String var1, Throwable var2, int var3);

    public void log(Throwable var1, int var2);

    default public void log(TableModel model) {
        this.log(model, 2);
    }

    default public void log(TableModel model, int msgLevel) {
        try (BufferedReader reader = new TextTable(model, new int[0]).getBufferedReader();){
            this.log(reader.lines(), 2);
        }
        catch (Throwable throwable) {
            throw new IllegalStateException(throwable);
        }
    }

    default public void log(Stream<String> stream) {
        this.log(stream, 2);
    }

    default public void log(Stream<String> stream, int msgLevel) {
        stream.forEach(t -> this.log((String)t, msgLevel));
    }

    default public void log(File file, int lineno, String message) {
        this.log(String.valueOf(file) + ":" + String.valueOf(lineno) + ": " + message);
    }

    default public void log() {
        this.log(2);
    }

    default public void log(int msgLevel) {
        this.log("", msgLevel);
    }
}

