/*
 * Decompiled with CFR 0.152.
 */
package ball.util.ant.taskdefs;

import ball.swing.table.SimpleTableModel;
import ball.util.ant.taskdefs.AnnotatedAntTask;
import ball.util.ant.taskdefs.AntTask;
import ball.util.ant.taskdefs.ClasspathDelegateAntTask;
import ball.util.ant.taskdefs.ConfigurableAntTask;
import ball.util.ant.taskdefs.NotNull;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.ClasspathUtils;

public abstract class PatternTask
extends Task
implements AnnotatedAntTask,
ClasspathDelegateAntTask,
ConfigurableAntTask {
    private ClasspathUtils.Delegate delegate = null;
    @NotNull
    private String pattern = null;
    @NotNull
    private String input = null;

    @Override
    public void init() throws BuildException {
        super.init();
        ClasspathDelegateAntTask.super.init();
        ConfigurableAntTask.super.init();
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        AnnotatedAntTask.super.execute();
    }

    @Generated
    protected PatternTask() {
    }

    @Override
    @Generated
    public ClasspathUtils.Delegate delegate() {
        return this.delegate;
    }

    @Override
    @Generated
    public PatternTask delegate(ClasspathUtils.Delegate delegate) {
        this.delegate = delegate;
        return this;
    }

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public void setInput(String input) {
        this.input = input;
    }

    @AntTask(value="pattern-split")
    public static class Split
    extends PatternTask {
        @Override
        public void execute() throws BuildException {
            super.execute();
            try {
                SimpleTableModel table = new SimpleTableModel((Object[][])new Object[0][], 2);
                Pattern pattern = Pattern.compile(this.getPattern());
                table.row("", String.valueOf(pattern));
                String input = this.getInput();
                table.row("", String.valueOf(input));
                String[] strings = pattern.split(input);
                for (int i = 0; i < strings.length; ++i) {
                    table.row(String.valueOf(i), strings[i]);
                }
                this.log(table);
            }
            catch (PatternSyntaxException exception) {
                this.log(exception.getMessage(), 0);
                throw new BuildException();
            }
            catch (BuildException exception) {
                throw exception;
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new BuildException(exception);
            }
        }

        @Generated
        public Split() {
        }

        @Generated
        public String toString() {
            return "PatternTask.Split()";
        }
    }

    @AntTask(value="pattern-matches")
    public static class Matches
    extends PatternTask {
        @Override
        public void execute() throws BuildException {
            super.execute();
            try {
                SimpleTableModel table = new SimpleTableModel((Object[][])new Object[0][], 2);
                Pattern pattern = Pattern.compile(this.getPattern());
                table.row("", String.valueOf(pattern));
                String input = this.getInput();
                table.row("", String.valueOf(input));
                Matcher matcher = pattern.matcher(input);
                boolean matches = matcher.matches();
                table.row("", String.valueOf(matches));
                if (matches) {
                    int n = matcher.groupCount();
                    for (int i = 0; i <= n; ++i) {
                        table.row(String.valueOf(i), this.tab(matcher.start(i)) + matcher.group(i));
                    }
                }
                this.log(table);
            }
            catch (PatternSyntaxException exception) {
                this.log(exception.getMessage(), 0);
                throw new BuildException();
            }
            catch (BuildException exception) {
                throw exception;
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new BuildException(exception);
            }
        }

        private String tab(int count) {
            return String.join((CharSequence)"", Collections.nCopies(count, " "));
        }

        @Generated
        public Matches() {
        }

        @Generated
        public String toString() {
            return "PatternTask.Matches()";
        }
    }
}

