/*
 * Decompiled with CFR 0.152.
 */
package ball.util.ant.taskdefs;

import ball.annotation.processing.ClassFileProcessor;
import ball.util.ant.taskdefs.AnnotatedAntTask;
import ball.util.ant.taskdefs.AntTask;
import ball.util.ant.taskdefs.ClasspathDelegateAntTask;
import java.io.File;
import java.lang.reflect.Modifier;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import lombok.Generated;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.ClasspathUtils;

@AntTask(value="process-class-files")
public class ProcessClassFilesTask
extends Task
implements AnnotatedAntTask,
ClasspathDelegateAntTask {
    private ClasspathUtils.Delegate delegate = null;
    private File basedir = null;
    private Path srcPath = null;
    private File destdir = null;
    private StandardJavaFileManager fm = null;

    public void setSrcdir(Path srcdir) {
        if (this.srcPath == null) {
            this.srcPath = srcdir;
        } else {
            this.srcPath.append(srcdir);
        }
    }

    public Path createSrc() {
        if (this.srcPath == null) {
            this.srcPath = new Path(this.getProject());
        }
        return this.srcPath.createPath();
    }

    @Override
    public void init() throws BuildException {
        super.init();
        ClasspathDelegateAntTask.super.init();
        try {
            this.fm = ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null);
        }
        catch (BuildException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new BuildException(throwable);
        }
    }

    @Override
    public void execute() throws BuildException {
        block12: {
            super.execute();
            AnnotatedAntTask.super.execute();
            try {
                if (this.getBasedir() == null) {
                    this.setBasedir(this.getProject().resolveFile("."));
                }
                if (this.getDestdir() == null) {
                    this.setDestdir(this.getBasedir());
                }
                List srcPaths = Stream.of(this.createSrc().list()).map(File::new).collect(Collectors.toList());
                List classPaths = Stream.of(this.delegate.getClasspath().list()).map(File::new).collect(Collectors.toList());
                this.fm.setLocation(StandardLocation.SOURCE_PATH, srcPaths);
                this.fm.setLocation(StandardLocation.PLATFORM_CLASS_PATH, classPaths);
                this.fm.setLocation(StandardLocation.CLASS_PATH, classPaths);
                this.fm.setLocation(StandardLocation.CLASS_OUTPUT, Arrays.asList(this.getDestdir()));
                ClassLoader loader = this.fm.getClassLoader(StandardLocation.CLASS_PATH);
                if (loader instanceof URLClassLoader) {
                    loader = URLClassLoader.newInstance(((URLClassLoader)loader).getURLs(), this.getClass().getClassLoader());
                }
                HashSet types = new HashSet();
                ArrayList<Class<ClassFileProcessor>> processors = new ArrayList<Class<ClassFileProcessor>>();
                HashSet<String> names = new HashSet<String>();
                for (String string : ClassFileProcessor.list(this.fm)) {
                    try {
                        Class<?> type = Class.forName(string, true, loader);
                        types.add(type);
                        if (Modifier.isAbstract(type.getModifiers()) || !ClassFileProcessor.class.isAssignableFrom(type)) continue;
                        processors.add(type.asSubclass(ClassFileProcessor.class));
                    }
                    catch (Throwable throwable) {
                        names.add(string);
                    }
                }
                if (names.isEmpty()) {
                    for (Class clazz : processors) {
                        ((ClassFileProcessor)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).process(types, this.fm);
                    }
                    break block12;
                }
                throw new BuildException("Failed to load " + names);
            }
            catch (BuildException exception) {
                throw exception;
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new BuildException(throwable);
            }
        }
    }

    @Generated
    public ProcessClassFilesTask() {
    }

    @Generated
    public String toString() {
        return "ProcessClassFilesTask(delegate=" + this.delegate() + ", basedir=" + this.getBasedir() + ", srcPath=" + this.getSrcPath() + ", destdir=" + this.getDestdir() + ", fm=" + this.fm + ")";
    }

    @Override
    @Generated
    public ClasspathUtils.Delegate delegate() {
        return this.delegate;
    }

    @Override
    @Generated
    public ProcessClassFilesTask delegate(ClasspathUtils.Delegate delegate) {
        this.delegate = delegate;
        return this;
    }

    @Generated
    public File getBasedir() {
        return this.basedir;
    }

    @Generated
    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    @Generated
    public Path getSrcPath() {
        return this.srcPath;
    }

    @Generated
    public File getDestdir() {
        return this.destdir;
    }

    @Generated
    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }
}

