/*
 * Decompiled with CFR 0.152.
 */
package ball.util.ant.taskdefs;

import ball.util.ant.taskdefs.AnnotatedAntTask;
import ball.util.ant.taskdefs.AntTask;
import ball.util.ant.taskdefs.ClasspathDelegateAntTask;
import ball.util.ant.taskdefs.ConfigurableAntTask;
import ball.util.ant.taskdefs.NotNull;
import ball.xml.XalanConstants;
import java.io.ByteArrayOutputStream;
import java.io.File;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.util.ClasspathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

@AntTask(value="xpath-evaluate")
public class XPathEvaluateTask
extends Task
implements AnnotatedAntTask,
ClasspathDelegateAntTask,
ConfigurableAntTask,
XalanConstants {
    private ClasspathUtils.Delegate delegate = null;
    @NotNull
    private File file = null;
    @NotNull
    private String expression = null;
    @NotNull
    private QName qname = XPathConstants.STRING;
    @NotNull
    private int tab = 2;

    public void setQname(String name) throws IllegalArgumentException {
        try {
            this.qname = (QName)XPathConstants.class.getField(name.toUpperCase()).get(null);
        }
        catch (Exception exception) {
            this.qname = QName.valueOf(name);
        }
    }

    @Override
    public void init() throws BuildException {
        super.init();
        ClasspathDelegateAntTask.super.init();
        ConfigurableAntTask.super.init();
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        AnnotatedAntTask.super.execute();
        try {
            this.log(String.valueOf(this.getFile()));
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(this.getFile());
            this.log(this.getExpression());
            XPathExpression expression = XPathFactory.newInstance().newXPath().compile(this.getExpression());
            QName qname = this.getQname();
            Object value = expression.evaluate(document, qname);
            if (XPathConstants.NODESET.equals(qname)) {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", this.tab > 0 ? "yes" : "no");
                transformer.setOutputProperty(XALAN_INDENT_AMOUNT.toString(), String.valueOf(this.tab));
                NodeList nodeset = (NodeList)value;
                for (int i = 0; i < nodeset.getLength(); ++i) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    transformer.transform(new DOMSource(nodeset.item(i)), new StreamResult(out));
                    this.log(out.toString("UTF-8"));
                }
            } else {
                this.log(String.valueOf(value));
            }
        }
        catch (BuildException exception) {
            throw exception;
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new BuildException(exception);
        }
    }

    @Generated
    public XPathEvaluateTask() {
    }

    @Generated
    public String toString() {
        return "XPathEvaluateTask(delegate=" + this.delegate() + ", file=" + this.getFile() + ", expression=" + this.getExpression() + ", qname=" + this.getQname() + ", tab=" + this.getTab() + ")";
    }

    @Override
    @Generated
    public ClasspathUtils.Delegate delegate() {
        return this.delegate;
    }

    @Override
    @Generated
    public XPathEvaluateTask delegate(ClasspathUtils.Delegate delegate) {
        this.delegate = delegate;
        return this;
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Generated
    public void setFile(File file) {
        this.file = file;
    }

    @Generated
    public String getExpression() {
        return this.expression;
    }

    @Generated
    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Generated
    public QName getQname() {
        return this.qname;
    }

    @Generated
    public int getTab() {
        return this.tab;
    }

    @Generated
    public void setTab(int tab) {
        this.tab = tab;
    }
}

