/*
 * Decompiled with CFR 0.152.
 */
package ball.util.stream;

import ball.util.DispatchSpliterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;

public interface Combinations<T>
extends Stream<List<T>> {
    public static <T> Stream<List<T>> of(int size0, int sizeN, Predicate<List<T>> predicate, Collection<T> collection) {
        SpliteratorSupplier supplier = new SpliteratorSupplier<T>().collection(collection).size0(size0).sizeN(sizeN).predicate(predicate);
        return supplier.stream();
    }

    public static <T> Stream<List<T>> of(int size, Collection<T> collection) {
        return Combinations.of(size, size, null, collection);
    }

    public static class SpliteratorSupplier<T>
    implements Supplier<Spliterator<List<T>>> {
        private int characteristics = 17728;
        private Collection<? extends T> collection = null;
        private int size0 = -1;
        private int sizeN = -1;
        private Predicate<List<T>> predicate = null;

        public SpliteratorSupplier<T> size(int size) {
            return this.size0(size).sizeN(size);
        }

        public Stream<List<T>> stream() {
            return StreamSupport.stream(this.get(), false);
        }

        @Override
        public Spliterator<List<T>> get() {
            if (this.size0() == -1 && this.sizeN() == -1) {
                this.size(this.collection.size());
            } else if (this.size0() == -1) {
                this.size0(this.sizeN());
            } else if (this.sizeN() == -1) {
                this.sizeN(this.size0());
            }
            return new Start();
        }

        @Generated
        private SpliteratorSupplier() {
        }

        @Generated
        public String toString() {
            return "Combinations.SpliteratorSupplier(characteristics=" + this.characteristics() + ", collection=" + this.collection() + ", size0=" + this.size0() + ", sizeN=" + this.sizeN() + ", predicate=" + this.predicate() + ")";
        }

        @Generated
        public int characteristics() {
            return this.characteristics;
        }

        @Generated
        public SpliteratorSupplier<T> characteristics(int characteristics) {
            this.characteristics = characteristics;
            return this;
        }

        @Generated
        public Collection<? extends T> collection() {
            return this.collection;
        }

        @Generated
        public SpliteratorSupplier<T> collection(Collection<? extends T> collection) {
            this.collection = collection;
            return this;
        }

        @Generated
        public int size0() {
            return this.size0;
        }

        @Generated
        public SpliteratorSupplier<T> size0(int size0) {
            this.size0 = size0;
            return this;
        }

        @Generated
        public int sizeN() {
            return this.sizeN;
        }

        @Generated
        public SpliteratorSupplier<T> sizeN(int sizeN) {
            this.sizeN = sizeN;
            return this;
        }

        @Generated
        public Predicate<List<T>> predicate() {
            return this.predicate;
        }

        @Generated
        public SpliteratorSupplier<T> predicate(Predicate<List<T>> predicate) {
            this.predicate = predicate;
            return this;
        }

        private class ForCombination
        extends DispatchSpliterator<List<T>> {
            private final List<T> combination;

            public ForCombination(List<T> combination) {
                super(1L, SpliteratorSupplier.this.characteristics());
                this.combination = Objects.requireNonNull(combination);
            }

            @Override
            protected Spliterator<Supplier<Spliterator<List<T>>>> spliterators() {
                Supplier<Spliterator> supplier = () -> Stream.of(this.combination).spliterator();
                return Stream.of(supplier).spliterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super List<T>> consumer) {
                Predicate predicate = SpliteratorSupplier.this.predicate();
                return (this.combination.isEmpty() || predicate == null || predicate.test(this.combination)) && super.tryAdvance(consumer);
            }

            public String toString() {
                return String.valueOf(this.combination);
            }
        }

        private class ForPrefix
        extends DispatchSpliterator<List<T>> {
            private final int size;
            private final List<T> prefix;
            private final List<T> remaining;

            public ForPrefix(int size, List<T> prefix, List<T> remaining) {
                super(ForPrefix.binomial(remaining.size(), size), SpliteratorSupplier.this.characteristics());
                this.size = size;
                this.prefix = Objects.requireNonNull(prefix);
                this.remaining = Objects.requireNonNull(remaining);
            }

            @Override
            protected Spliterator<Supplier<Spliterator<List<T>>>> spliterators() {
                LinkedList<Supplier<Spliterator>> list = new LinkedList<Supplier<Spliterator>>();
                if (this.prefix.size() < this.size) {
                    int n = this.remaining.size();
                    for (int i = 0; i < n; ++i) {
                        LinkedList prefix = new LinkedList(this.prefix);
                        LinkedList remaining = new LinkedList(this.remaining);
                        prefix.add(remaining.remove(i));
                        list.add(() -> new ForPrefix(this.size, prefix, remaining));
                    }
                } else if (this.prefix.size() == this.size) {
                    list.add(() -> new ForCombination(this.prefix));
                } else {
                    throw new IllegalStateException();
                }
                return list.spliterator();
            }

            @Override
            public boolean tryAdvance(Consumer<? super List<T>> consumer) {
                Predicate predicate = SpliteratorSupplier.this.predicate();
                return (this.prefix.isEmpty() || predicate == null || predicate.test(this.prefix)) && super.tryAdvance(consumer);
            }

            @Override
            public long estimateSize() {
                return ForPrefix.binomial(this.remaining.size(), this.size);
            }

            public String toString() {
                return this.prefix + ":" + this.remaining + "/" + Arrays.asList(this.size);
            }
        }

        private class ForSize
        extends DispatchSpliterator<List<T>> {
            private final int size;

            public ForSize(int size) {
                super(ForSize.binomial(SpliteratorSupplier.this.collection().size(), size), SpliteratorSupplier.this.characteristics());
                this.size = size;
            }

            @Override
            protected Spliterator<Supplier<Spliterator<List<T>>>> spliterators() {
                Supplier<Spliterator> supplier = () -> new ForPrefix(this.size, new LinkedList(), new LinkedList(SpliteratorSupplier.this.collection()));
                return Stream.of(supplier).spliterator();
            }

            @Override
            public long estimateSize() {
                return ForSize.binomial(SpliteratorSupplier.this.collection().size(), this.size);
            }

            public String toString() {
                return SpliteratorSupplier.this.collection() + "/" + Arrays.asList(this.size);
            }
        }

        private class Start
        extends DispatchSpliterator<List<T>> {
            public Start() {
                super(Start.binomial(SpliteratorSupplier.this.collection().size(), SpliteratorSupplier.this.size0(), SpliteratorSupplier.this.sizeN()), SpliteratorSupplier.this.characteristics());
            }

            @Override
            protected Spliterator<Supplier<Spliterator<List<T>>>> spliterators() {
                LinkedList list = new LinkedList();
                IntStream.rangeClosed(Math.min(SpliteratorSupplier.this.size0(), SpliteratorSupplier.this.sizeN()), Math.max(SpliteratorSupplier.this.size0(), SpliteratorSupplier.this.sizeN())).filter(t -> SpliteratorSupplier.this.collection.size() >= t).forEach(t -> list.add(() -> new ForSize(t)));
                if (SpliteratorSupplier.this.size0() > SpliteratorSupplier.this.sizeN()) {
                    Collections.reverse(list);
                }
                return list.spliterator();
            }

            @Override
            public long estimateSize() {
                return Start.binomial(SpliteratorSupplier.this.collection().size(), SpliteratorSupplier.this.size0(), SpliteratorSupplier.this.sizeN());
            }

            public String toString() {
                return SpliteratorSupplier.this.collection() + "/" + Arrays.asList(SpliteratorSupplier.this.size0(), SpliteratorSupplier.this.sizeN());
            }
        }
    }
}

