/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.maven.ParserClassPathConfiguration;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.plugins.backbone.BackbonePlugin;
import dev.hilla.parser.plugins.model.ModelPlugin;
import dev.hilla.parser.plugins.nonnull.NonnullPlugin;
import dev.hilla.parser.plugins.transfertypes.TransferTypesPlugin;
import dev.hilla.parser.utils.ConfigList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;

public final class ParserConfiguration {
    private ParserClassPathConfiguration classPath;
    private String endpointAnnotation;
    private String endpointExposedAnnotation;
    private String openAPIPath;
    private Plugins plugins;

    public Optional<ParserClassPathConfiguration> getClassPath() {
        return Optional.ofNullable(this.classPath);
    }

    public Optional<String> getEndpointAnnotation() {
        return Optional.ofNullable(this.endpointAnnotation);
    }

    public Optional<String> getEndpointExposedAnnotation() {
        return Optional.ofNullable(this.endpointExposedAnnotation);
    }

    public Optional<String> getOpenAPIPath() {
        return Optional.ofNullable(this.openAPIPath);
    }

    public Optional<Plugins> getPlugins() {
        return Optional.ofNullable(this.plugins);
    }

    static class PluginsProcessor
    extends ConfigList.Processor<Plugin> {
        private static final Set<Plugin> defaults = Set.of(new Plugin(TransferTypesPlugin.class.getName()), new Plugin(BackbonePlugin.class.getName()), new Plugin(NonnullPlugin.class.getName()), new Plugin(ModelPlugin.class.getName()));

        public PluginsProcessor() {
            super(defaults);
        }
    }

    public static class Plugins
    implements ConfigList<Plugin> {
        private final Set<Plugin> disable = new HashSet<Plugin>();
        private final boolean disableAllDefaults = false;
        private final Set<Plugin> use = new HashSet<Plugin>();

        public Plugins() {
        }

        public Plugins(@Nonnull Collection<Plugin> use, @Nonnull Collection<Plugin> disable) {
            this.disable.addAll(disable);
            this.use.addAll(use);
        }

        public Set<Plugin> getDisabledOptions() {
            return this.disable;
        }

        public Set<Plugin> getUsedOptions() {
            return this.use;
        }

        public boolean shouldAllDefaultsBeDisabled() {
            return false;
        }
    }

    public static class Plugin {
        private PluginConfiguration configuration;
        private String name;
        private Integer order;

        public Plugin() {
        }

        public Plugin(String name) {
            this.name = name;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Plugin)) {
                return false;
            }
            return Objects.equals(this.name, ((Plugin)other).name);
        }

        public PluginConfiguration getConfiguration() {
            return this.configuration;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        public Integer getOrder() {
            return this.order;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

