/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.maven;

import dev.hilla.maven.GeneratorException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.maven.plugin.logging.Log;

final class GeneratorShellRunner {
    private static final boolean IS_WINDOWS;
    private static final String TSGEN;
    private final List<String> arguments = new ArrayList<String>();
    private final Log logger;

    public GeneratorShellRunner(File baseDir, Log logger) {
        this.logger = logger;
        if (IS_WINDOWS) {
            this.arguments.add("cmd.exe");
            this.arguments.add("/c");
        }
        this.arguments.add(Paths.get("node_modules", ".bin", TSGEN).toString());
    }

    public void add(String ... args) {
        this.arguments.addAll(List.of(args));
    }

    public void run(String input) throws InterruptedException, IOException {
        Objects.requireNonNull(input);
        this.logger.debug((CharSequence)String.format("Executing command: %s", String.join((CharSequence)" ", this.arguments)));
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(this.arguments).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT);
        Process process = builder.start();
        try (OutputStream stdin = process.getOutputStream();){
            stdin.write(input.getBytes(StandardCharsets.UTF_8));
        }
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new GeneratorException("Generator execution failed with exit code " + exitCode);
        }
        this.logger.info((CharSequence)("The Generator process finished with the exit code " + exitCode));
    }

    public void runNpmInstall() throws InterruptedException, IOException {
        ProcessBuilder builder = new ProcessBuilder(new String[0]).command(List.of("npm", "install")).inheritIO();
        Process process = builder.start();
        int exitCode = process.waitFor();
        if (exitCode != 0) {
            throw new GeneratorException("`npm install` failed with exit code " + exitCode);
        }
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        IS_WINDOWS = osName.contains("windows");
        TSGEN = IS_WINDOWS ? "tsgen.cmd" : "tsgen";
    }
}

