/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import dev.hilla.parser.core.ParserConfig;
import dev.hilla.parser.core.PluginExecutor;
import dev.hilla.parser.core.PluginManager;
import dev.hilla.parser.core.RootNode;
import dev.hilla.parser.core.SharedStorage;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import io.swagger.v3.oas.models.OpenAPI;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parser {
    private static final Logger logger = LoggerFactory.getLogger(Parser.class);
    private final ParserConfig config;
    private final SharedStorage storage;

    public Parser(@Nonnull ParserConfig config) {
        this.config = Objects.requireNonNull(config);
        this.storage = new SharedStorage(config);
    }

    public OpenAPI execute() {
        logger.debug("Executing JVM Parser");
        try (ScanResult scanResult = new ClassGraph().enableAllInfo().enableSystemJarsAndModules().overrideClasspath(this.config.getClassPathElements()).scan();){
            RootNode rootNode = new RootNode(scanResult, this.storage.getOpenAPI());
            PluginManager pluginManager = new PluginManager(this.storage.getParserConfig().getPlugins());
            pluginManager.setStorage(this.storage);
            PluginExecutor pluginExecutor = new PluginExecutor(pluginManager, rootNode);
            pluginExecutor.execute();
        }
        return this.storage.getOpenAPI();
    }

    @Nonnull
    public SharedStorage getStorage() {
        return this.storage;
    }
}

