/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import dev.hilla.parser.core.AbstractParserConfig;
import dev.hilla.parser.core.ParserException;
import dev.hilla.parser.core.Plugin;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParserConfig
extends AbstractParserConfig {
    private final SortedSet<Plugin> plugins = new TreeSet<Plugin>(Comparator.comparingInt(Plugin::getOrder));
    private Set<String> classPathElements;
    private String endpointAnnotationName;
    private String endpointExposedAnnotationName;
    private OpenAPI openAPI;

    private ParserConfig() {
    }

    @Override
    @Nonnull
    public Set<String> getClassPathElements() {
        return this.classPathElements;
    }

    @Override
    @Nonnull
    public String getEndpointAnnotationName() {
        return this.endpointAnnotationName;
    }

    @Override
    @Nonnull
    public String getEndpointExposedAnnotationName() {
        return this.endpointExposedAnnotationName;
    }

    @Override
    @Nonnull
    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    @Nonnull
    public SortedSet<Plugin> getPlugins() {
        return this.plugins;
    }

    private static final class OpenAPIParser {
        private OpenAPI value;

        private OpenAPIParser() {
        }

        public OpenAPI getValue() {
            return this.value;
        }

        public void parse(FileSource spec) throws IOException {
            ObjectMapper mapper = spec.getType().getMapper();
            ObjectReader reader = this.value != null ? mapper.readerForUpdating((Object)this.value) : mapper.reader();
            this.value = (OpenAPI)reader.readValue(spec.getSrc(), OpenAPI.class);
        }
    }

    private static final class FileSource {
        private final String src;
        private final OpenAPIFileType type;

        public FileSource(String src, OpenAPIFileType type) {
            this.src = src;
            this.type = type;
        }

        public String getSrc() {
            return this.src;
        }

        public OpenAPIFileType getType() {
            return this.type;
        }
    }

    public static final class Builder {
        private static final Logger logger = LoggerFactory.getLogger(Builder.class);
        private final List<Consumer<ParserConfig>> actions = new ArrayList<Consumer<ParserConfig>>();
        private FileSource openAPISpec;

        @Nonnull
        public Builder addPlugin(@Nonnull Plugin plugin) {
            Objects.requireNonNull(plugin);
            this.actions.add(config -> config.plugins.add(plugin));
            return this;
        }

        @Nonnull
        public Builder adjustOpenAPI(@Nonnull Consumer<OpenAPI> action) {
            Objects.requireNonNull(action);
            this.actions.add(config -> action.accept(config.openAPI));
            return this;
        }

        @Nonnull
        public Builder classPath(@Nonnull String[] classPathElements) {
            return this.classPath(classPathElements, true);
        }

        @Nonnull
        public Builder classPath(@Nonnull String[] classPathElements, boolean override) {
            return this.classPath(Arrays.asList(Objects.requireNonNull(classPathElements)), override);
        }

        @Nonnull
        public Builder classPath(@Nonnull Collection<String> classPathElements, boolean override) {
            Objects.requireNonNull(classPathElements);
            this.actions.add(config -> {
                if (override || config.classPathElements == null) {
                    config.classPathElements = new HashSet<String>(classPathElements);
                }
            });
            return this;
        }

        @Nonnull
        public Builder classPath(@Nonnull Collection<String> classPathElements) {
            return this.classPath(classPathElements, true);
        }

        @Nonnull
        public Builder endpointAnnotation(@Nonnull String annotationFullyQualifiedName, boolean override) {
            Objects.requireNonNull(annotationFullyQualifiedName);
            this.actions.add(config -> {
                if (override || config.endpointAnnotationName == null) {
                    config.endpointAnnotationName = annotationFullyQualifiedName;
                }
            });
            return this;
        }

        @Nonnull
        public Builder endpointAnnotation(@Nonnull String annotationQualifiedName) {
            return this.endpointAnnotation(annotationQualifiedName, true);
        }

        @Nonnull
        public Builder endpointExposedAnnotation(@Nonnull String annotationFullyQualifiedName, boolean override) {
            Objects.requireNonNull(annotationFullyQualifiedName);
            this.actions.add(config -> {
                if (override || config.endpointExposedAnnotationName == null) {
                    config.endpointExposedAnnotationName = annotationFullyQualifiedName;
                }
            });
            return this;
        }

        @Nonnull
        public Builder endpointExposedAnnotation(@Nonnull String annotationQualifiedName) {
            return this.endpointExposedAnnotation(annotationQualifiedName, true);
        }

        public ParserConfig finish() {
            logger.debug("Building JVM Parser config.");
            ParserConfig config = new ParserConfig();
            logger.debug("Loading OpenAPI configuration.");
            config.openAPI = this.prepareOpenAPI();
            logger.debug("Applying configuration changed defined by the user.");
            this.actions.forEach(action -> action.accept(config));
            Objects.requireNonNull(config.classPathElements, "[JVM Parser] classPath is not provided.");
            Objects.requireNonNull(config.endpointAnnotationName, "[JVM Parser] endpointAnnotationName is not provided.");
            return config;
        }

        @Nonnull
        public Builder openAPISource(@Nonnull String src, @Nonnull OpenAPIFileType type) {
            this.openAPISpec = new FileSource(Objects.requireNonNull(src), Objects.requireNonNull(type));
            return this;
        }

        @Nonnull
        public <P extends Plugin> Builder plugins(@Nonnull Collection<P> plugins) {
            Objects.requireNonNull(plugins);
            this.actions.add(config -> {
                config.plugins.clear();
                config.plugins.addAll(plugins);
            });
            return this;
        }

        private OpenAPI prepareOpenAPI() {
            try {
                OpenAPIParser parser = new OpenAPIParser();
                String src = new String(Objects.requireNonNull(this.getClass().getResourceAsStream("OpenAPIBase.json")).readAllBytes());
                parser.parse(new FileSource(src, OpenAPIFileType.JSON));
                if (this.openAPISpec != null) {
                    parser.parse(this.openAPISpec);
                }
                return parser.getValue();
            }
            catch (IOException e) {
                throw new ParserException("Failed to parse openAPI specification", e);
            }
        }
    }

    public static enum OpenAPIFileType {
        JSON(Json.mapper()),
        YAML(Yaml.mapper());

        private final ObjectMapper mapper;

        private OpenAPIFileType(ObjectMapper mapper) {
            this.mapper = mapper;
        }

        public ObjectMapper getMapper() {
            return this.mapper;
        }
    }
}

