/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.models;

import dev.hilla.parser.models.AnnotationInfoModel;
import dev.hilla.parser.models.ReflectionSignatureModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.models.TypeArgumentModel;
import dev.hilla.parser.utils.Streams;
import io.github.classgraph.TypeArgument;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class TypeArgumentReflectionModel
extends TypeArgumentModel
implements ReflectionSignatureModel {
    private final AnnotatedType origin;
    private TypeArgument.Wildcard wildcard;

    TypeArgumentReflectionModel(AnnotatedType origin) {
        this.origin = origin;
    }

    private static boolean isNonNativeObjectType(AnnotatedType type) {
        return type.getType() != Object.class;
    }

    @Override
    public AnnotatedType get() {
        return this.origin;
    }

    @Override
    public TypeArgument.Wildcard getWildcard() {
        if (this.wildcard == null) {
            AnnotatedWildcardType specific;
            this.wildcard = this.origin instanceof AnnotatedWildcardType ? ((specific = (AnnotatedWildcardType)this.origin).getAnnotatedLowerBounds().length > 0 ? TypeArgument.Wildcard.SUPER : (!specific.getAnnotatedUpperBounds()[0].getType().equals(Object.class) ? TypeArgument.Wildcard.EXTENDS : TypeArgument.Wildcard.ANY)) : TypeArgument.Wildcard.NONE;
        }
        return this.wildcard;
    }

    @Override
    protected List<AnnotationInfoModel> prepareAnnotations() {
        return TypeArgumentReflectionModel.processAnnotations(this.origin.getAnnotations());
    }

    @Override
    protected List<SignatureModel> prepareAssociatedTypes() {
        Stream stream = this.origin instanceof AnnotatedWildcardType ? Streams.combine((Object[][])new AnnotatedType[][]{((AnnotatedWildcardType)this.origin).getAnnotatedLowerBounds(), ((AnnotatedWildcardType)this.origin).getAnnotatedUpperBounds()}) : Stream.of(this.origin);
        return stream.filter(TypeArgumentReflectionModel::isNonNativeObjectType).map(SignatureModel::of).distinct().collect(Collectors.toList());
    }
}

