/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.core;

import dev.hilla.parser.core.AbstractCompositePlugin;
import dev.hilla.parser.core.ParserException;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;

public final class PluginManager
extends AbstractCompositePlugin<PluginConfiguration> {
    private static final ClassLoader loader = PluginManager.class.getClassLoader();

    PluginManager(Collection<Plugin> plugins) {
        super((Plugin[])plugins.toArray(Plugin[]::new));
    }

    public static Plugin load(String name, PluginConfiguration configuration) {
        Class<? extends Plugin> cls = PluginManager.processClass(PluginManager.loadClass(name));
        Plugin instance = PluginManager.instantiatePlugin(cls);
        instance.setConfiguration(configuration);
        return instance;
    }

    private static Plugin instantiatePlugin(Class<? extends Plugin> pluginClass) {
        try {
            return pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ParserException(String.format("Cannot instantiate plugin '%s'", pluginClass.getName()), e);
        }
    }

    private static Class<?> loadClass(String name) {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new ParserException(String.format("Plugin '%s' is not found in the classpath", name), e);
        }
    }

    private static Class<? extends Plugin> processClass(Class<?> cls) {
        if (Plugin.class.isAssignableFrom(cls)) {
            return cls;
        }
        throw new ParserException(String.format("Plugin '%s' is not an instance of '%s' interface", cls.getName(), Plugin.class.getName()));
    }
}

