/*
 * Decompiled with CFR 0.152.
 */
package dev.hilla.parser.plugins.transfertypes;

import dev.hilla.mappedtypes.Order;
import dev.hilla.mappedtypes.Pageable;
import dev.hilla.mappedtypes.Sort;
import dev.hilla.parser.core.AbstractPlugin;
import dev.hilla.parser.core.Node;
import dev.hilla.parser.core.NodeDependencies;
import dev.hilla.parser.core.NodePath;
import dev.hilla.parser.core.Plugin;
import dev.hilla.parser.core.PluginConfiguration;
import dev.hilla.parser.models.ClassInfoModel;
import dev.hilla.parser.models.ClassRefSignatureModel;
import dev.hilla.parser.models.SignatureModel;
import dev.hilla.parser.plugins.backbone.BackbonePlugin;
import dev.hilla.parser.plugins.backbone.nodes.TypedNode;
import dev.hilla.runtime.transfertypes.EndpointSubscription;
import dev.hilla.runtime.transfertypes.Flux;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class TransferTypesPlugin
extends AbstractPlugin<PluginConfiguration> {
    private static final Map<String, Class<?>> classMap = new HashMap();

    public TransferTypesPlugin() {
        classMap.put("org.springframework.data.domain.Page", List.class);
        classMap.put("org.springframework.data.domain.Pageable", Pageable.class);
        classMap.put("org.springframework.data.domain.Sort$Order", Order.class);
        classMap.put("org.springframework.data.domain.Sort", Sort.class);
        classMap.put(UUID.class.getName(), String.class);
        classMap.put("reactor.core.publisher.Flux", Flux.class);
        classMap.put("dev.hilla.EndpointSubscription", EndpointSubscription.class);
    }

    public void enter(NodePath<?> nodePath) {
    }

    public void exit(NodePath<?> nodePath) {
    }

    public Collection<Class<? extends Plugin>> getRequiredPlugins() {
        return List.of(BackbonePlugin.class);
    }

    @Nonnull
    public NodeDependencies scan(@Nonnull NodeDependencies nodeDependencies) {
        return nodeDependencies.processChildNodes(this::processNodes).processRelatedNodes(this::processNodes);
    }

    private Node<?, ?> mapClassRefNodes(Node<?, ?> node) {
        if (!(node instanceof TypedNode)) {
            return node;
        }
        return (Node)((TypedNode)node).processType(this::processType);
    }

    private Stream<Node<?, ?>> processNodes(Stream<Node<?, ?>> nodes) {
        return nodes.map(this::mapClassRefNodes);
    }

    private SignatureModel processType(SignatureModel signature) {
        if (!(signature instanceof ClassRefSignatureModel)) {
            return signature;
        }
        ClassRefSignatureModel classRef = (ClassRefSignatureModel)signature;
        String className = classRef.getClassInfo().getName();
        if (!classMap.containsKey(className)) {
            return signature;
        }
        ClassInfoModel mappedClassInfo = ClassInfoModel.of(classMap.get(className));
        return ClassRefSignatureModel.of((ClassInfoModel)mappedClassInfo, (List)classRef.getTypeArguments(), (List)classRef.getAnnotations());
    }
}

