/*
 * Copyright 2019 IceRock MAG Inc. Use of this source code is governed by the Apache 2.0 license.
 */

package dev.icerock.moko.widgets.core.factory

import dev.icerock.moko.graphics.Color
import dev.icerock.moko.widgets.core.widget.TextWidget
import dev.icerock.moko.widgets.core.ViewFactory
import dev.icerock.moko.widgets.core.style.background.Background
import dev.icerock.moko.widgets.core.style.background.Fill
import dev.icerock.moko.widgets.core.style.view.MarginValues
import dev.icerock.moko.widgets.core.style.view.TextHorizontalAlignment
import dev.icerock.moko.widgets.core.style.view.TextStyle
import dev.icerock.moko.widgets.core.style.view.WidgetSize

expect class SystemTextViewFactory(
    background: Background<Fill.Solid>? = null,
    textStyle: TextStyle<Color>? = null,
    textHorizontalAlignment: TextHorizontalAlignment? = null,
    margins: MarginValues? = null,
    isHtmlConverted: Boolean = false
) : ViewFactory<TextWidget<out WidgetSize>>
