/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.websocket.client;

import dev.ikm.tinkar.common.id.PublicId;
import dev.ikm.tinkar.common.service.PrimitiveDataSearchResult;
import dev.ikm.tinkar.common.service.PrimitiveDataService;
import dev.ikm.tinkar.common.util.uuid.UuidUtil;
import dev.ikm.tinkar.entity.EntityService;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.eventloop.Eventloop;
import io.activej.http.AsyncHttpClient;
import io.activej.http.HttpRequest;
import io.activej.http.WebSocket;
import io.activej.inject.annotation.Inject;
import io.activej.inject.annotation.Provides;
import io.activej.inject.module.Module;
import io.activej.launcher.Launcher;
import io.activej.service.ServiceGraphModule;
import java.net.URI;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.ObjIntConsumer;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableIntList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProviderWebsocketClient
extends Launcher
implements PrimitiveDataService {
    private static final Logger LOG = LoggerFactory.getLogger(DataProviderWebsocketClient.class);
    private static final Integer wsKey = 1;
    private final URI uri;
    @Inject
    AsyncHttpClient httpClient;
    @Inject
    Eventloop eventloop;
    ConcurrentHashMap<Integer, WebSocket> wsMap = new ConcurrentHashMap();

    public DataProviderWebsocketClient(URI uri) {
        this.uri = uri;
    }

    public static void main(String[] args) throws Exception {
        DataProviderWebsocketClient client = new DataProviderWebsocketClient(new URI("ws://127.0.0.1:8080/"));
        client.launch(args);
    }

    @Provides
    Eventloop eventloop() {
        return Eventloop.create();
    }

    @Provides
    AsyncHttpClient client(Eventloop eventloop) {
        return AsyncHttpClient.create((Eventloop)eventloop);
    }

    protected Module getModule() {
        return ServiceGraphModule.create();
    }

    protected void run() throws ExecutionException, InterruptedException {
        String url = this.args.length != 0 ? this.args[0] : "ws://127.0.0.1:8080/";
        LOG.info("\nWeb Socket request: " + url);
        CompletableFuture future = this.eventloop.submit(() -> this.getEntity(url, -2147483647));
        future.get();
        future = this.eventloop.submit(() -> this.getEntity(url, -2147483646));
        future.get();
    }

    private void getEntity(String url, int nid) {
        LOG.info("Sending nid: " + nid);
        ByteBuf buf = ByteBufPool.allocate((int)32);
        buf.writeByte(PrimitiveDataService.RemoteOperations.GET_BYTES.token);
        buf.writeInt(nid);
        this.httpClient.webSocketRequest(HttpRequest.get((String)url)).then(webSocket -> webSocket.writeMessage(WebSocket.Message.binary((ByteBuf)buf)).then(() -> ((WebSocket)webSocket).readMessage()).whenResult(message -> {
            ByteBuf readBuf = message.getBuf();
            int length = readBuf.readInt();
            byte[] readData = new byte[length];
            readBuf.read(readData);
            LOG.info("Received: " + String.valueOf(EntityService.get().unmarshalChronology(readData)));
        }).whenComplete(() -> ((WebSocket)webSocket).close()));
    }

    public long writeSequence() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        WebSocket ws = this.wsMap.remove(wsKey);
        if (ws != null) {
            ws.close();
        }
    }

    public int nidForUuids(UUID ... uuids) {
        try {
            return this.nidForLongArray(UuidUtil.asArray((UUID[])uuids));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public int nidForUuids(ImmutableList<UUID> uuidList) {
        try {
            return this.nidForLongArray(UuidUtil.asArray(uuidList));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean hasUuid(UUID uuid) {
        throw new UnsupportedOperationException();
    }

    public boolean hasPublicId(PublicId publicId) {
        throw new UnsupportedOperationException();
    }

    public void forEach(ObjIntConsumer<byte[]> action) {
        throw new UnsupportedOperationException();
    }

    public void forEachParallel(ObjIntConsumer<byte[]> action) {
        throw new UnsupportedOperationException();
    }

    public void forEachParallel(ImmutableIntList nids, ObjIntConsumer<byte[]> action) {
        throw new UnsupportedOperationException();
    }

    public byte[] getBytes(int nid) {
        ByteBuf buf = ByteBufPool.allocate((int)32);
        buf.writeByte(PrimitiveDataService.RemoteOperations.GET_BYTES.token);
        buf.writeInt(nid);
        AtomicReference readDataReference = new AtomicReference();
        WebSocket ws = this.webSocket();
        CompletableFuture future = this.eventloop.submit(() -> ws.writeMessage(WebSocket.Message.binary((ByteBuf)buf)).then(() -> ((WebSocket)ws).readMessage()).whenResult(message -> {
            ByteBuf readBuf = message.getBuf();
            int length = readBuf.readInt();
            byte[] readData = new byte[length];
            readBuf.read(readData);
            readDataReference.set(readData);
            LOG.info("Received: " + String.valueOf(EntityService.get().unmarshalChronology(readData)));
        }));
        try {
            future.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return (byte[])readDataReference.get();
    }

    public byte[] merge(int nid, int patternNid, int referencedComponentNid, byte[] value, Object sourceObject) {
        throw new UnsupportedOperationException();
    }

    public PrimitiveDataSearchResult[] search(String query, int maxResultSize) throws Exception {
        throw new UnsupportedOperationException();
    }

    public void forEachSemanticNidOfPattern(int patternNid, IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void forEachPatternNid(IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void forEachConceptNid(IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void forEachStampNid(IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void forEachSemanticNid(IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void forEachSemanticNidForComponent(int componentNid, IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public void forEachSemanticNidForComponentOfPattern(int componentNid, int patternNid, IntProcedure procedure) {
        throw new UnsupportedOperationException();
    }

    public String name() {
        return this.uri.toString();
    }

    private int nidForLongArray(long[] uuidParts) throws ExecutionException, InterruptedException {
        ByteBuf buf = ByteBufPool.allocate((int)32);
        buf.writeByte(PrimitiveDataService.RemoteOperations.NID_FOR_UUIDS.token);
        buf.writeInt(uuidParts.length);
        for (long part : uuidParts) {
            buf.writeLong(part);
        }
        AtomicInteger nid = new AtomicInteger();
        WebSocket ws = this.webSocket();
        CompletableFuture future = this.eventloop.submit(() -> ws.writeMessage(WebSocket.Message.binary((ByteBuf)buf)).then(() -> ((WebSocket)ws).readMessage()).whenResult(message -> {
            ByteBuf readBuf = message.getBuf();
            nid.set(readBuf.readInt());
        }));
        future.get();
        return nid.get();
    }

    WebSocket webSocket() {
        return this.wsMap.computeIfAbsent(wsKey, key -> {
            try {
                return (WebSocket)this.httpClient.webSocketRequest(HttpRequest.get((String)this.uri.toString())).toCompletableFuture().get();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }
}

