/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.websocket.client;

import com.google.auto.service.AutoService;
import dev.ikm.tinkar.common.service.DataServiceController;
import dev.ikm.tinkar.common.service.DataServiceProperty;
import dev.ikm.tinkar.common.service.DataUriOption;
import dev.ikm.tinkar.common.service.PrimitiveDataService;
import dev.ikm.tinkar.common.validation.ValidationRecord;
import dev.ikm.tinkar.common.validation.ValidationSeverity;
import dev.ikm.tinkar.provider.websocket.client.DataProviderWebsocketClient;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;

@AutoService(value={DataServiceController.class})
public class WebsocketServiceController
implements DataServiceController<PrimitiveDataService> {
    public static final String CONTROLLER_NAME = "Websocket";
    private static final DataServiceProperty passwordProperty = new DataServiceProperty("password", true, true);
    MutableMap<DataServiceProperty, String> providerProperties = Maps.mutable.empty();
    DataUriOption dataUriOption;

    public WebsocketServiceController() {
        this.providerProperties.put((Object)new DataServiceProperty("username", false, false), null);
        this.providerProperties.put((Object)passwordProperty, null);
    }

    public List<DataUriOption> providerOptions() {
        try {
            return List.of(new DataUriOption("localhost websocket", new URI("ws://127.0.0.1:8080/")));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public ValidationRecord[] validate(DataServiceProperty dataServiceProperty, Object value, Object target) {
        if (passwordProperty.equals((Object)dataServiceProperty) && value instanceof String) {
            String password = (String)value;
            if (password.isBlank()) {
                return new ValidationRecord[]{new ValidationRecord(ValidationSeverity.ERROR, "Password cannot be blank", target)};
            }
            if (password.length() < 5) {
                return new ValidationRecord[]{new ValidationRecord(ValidationSeverity.ERROR, "Password cannot be less than 5 characters", target)};
            }
            if (password.length() < 8) {
                return new ValidationRecord[]{new ValidationRecord(ValidationSeverity.WARNING, "Password recommended to be 8 or more characters", target), new ValidationRecord(ValidationSeverity.INFO, "Password is " + password.length() + " characters long", target)};
            }
            return new ValidationRecord[]{new ValidationRecord(ValidationSeverity.OK, "Password OK", target)};
        }
        return new ValidationRecord[0];
    }

    public String controllerName() {
        return CONTROLLER_NAME;
    }

    public ImmutableMap<DataServiceProperty, String> providerProperties() {
        return this.providerProperties.toImmutable();
    }

    public void setDataServiceProperty(DataServiceProperty key, String value) {
        this.providerProperties.put((Object)key, (Object)value);
    }

    public boolean isValidDataLocation(String name) {
        return name.toLowerCase(Locale.ROOT).startsWith("ws://");
    }

    public void setDataUriOption(DataUriOption dataUriOption) {
        this.dataUriOption = dataUriOption;
    }

    public Class<? extends PrimitiveDataService> serviceClass() {
        return DataProviderWebsocketClient.class;
    }

    public boolean running() {
        return false;
    }

    public void start() {
        try {
            DataProviderWebsocketClient client = new DataProviderWebsocketClient(this.dataUriOption.uri());
            client.launch(new String[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
    }

    public void save() {
    }

    public void reload() {
    }

    public PrimitiveDataService provider() {
        return null;
    }

    public String toString() {
        return CONTROLLER_NAME;
    }
}

