/*
 * Decompiled with CFR 0.152.
 */
package dev.ikm.tinkar.provider.websocket.server;

import dev.ikm.tinkar.common.service.PluggableService;
import dev.ikm.tinkar.common.service.PrimitiveDataService;
import io.activej.bytebuf.ByteBuf;
import io.activej.bytebuf.ByteBufPool;
import io.activej.http.AsyncServlet;
import io.activej.http.RoutingServlet;
import io.activej.http.WebSocket;
import io.activej.inject.annotation.Provides;
import io.activej.launchers.http.MultithreadedHttpServerLauncher;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProviderWebsocketServer
extends MultithreadedHttpServerLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(DataProviderWebsocketServer.class);
    private final ServiceLoader<PrimitiveDataService> serviceLoader = PluggableService.load(PrimitiveDataService.class);
    private final PrimitiveDataService dataService = this.serviceLoader.findFirst().get();

    public static void main(String[] args) throws Exception {
        DataProviderWebsocketServer server = new DataProviderWebsocketServer();
        server.launch(args);
    }

    @Provides
    AsyncServlet servlet() {
        AtomicInteger nid = new AtomicInteger();
        return RoutingServlet.create().mapWebSocket("/", webSocket -> webSocket.readMessage().whenResult(message -> {
            ByteBuf buf = message.getBuf();
            PrimitiveDataService.RemoteOperations operation = PrimitiveDataService.RemoteOperations.fromToken((byte)buf.readByte());
            nid.set(buf.readInt());
            LOG.info("Received: " + String.valueOf(operation) + " for: " + String.valueOf(nid));
        }).then(() -> {
            byte[] data = this.dataService.getBytes(nid.get());
            ByteBuf buf = ByteBufPool.allocate((int)data.length);
            buf.writeInt(data.length);
            buf.write(data);
            return webSocket.writeMessage(WebSocket.Message.binary((ByteBuf)buf));
        }));
    }
}

